<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContextualisedRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for General SIRI Request.
 * @subpackage Structs
 */
abstract class ContextualisedRequestStructure extends AbstractStructBase
{
    /**
     * The ServiceRequestContext
     * Meta informations extracted from the WSDL
     * - documentation: General request properties - typically configured rather than repeated on request.
     * - minOccurs: 0
     * @var \StructType\ServiceRequestContextStructure
     */
    public $ServiceRequestContext;
    /**
     * The RequestTimestamp
     * Meta informations extracted from the WSDL
     * - ref: RequestTimestamp
     * @var string
     */
    public $RequestTimestamp;
    /**
     * The AccountId
     * @var string
     */
    public $AccountId;
    /**
     * The AccountKey
     * @var string
     */
    public $AccountKey;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The RequestorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $RequestorRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ContextualisedRequestStructure
     * @uses ContextualisedRequestStructure::setServiceRequestContext()
     * @uses ContextualisedRequestStructure::setRequestTimestamp()
     * @uses ContextualisedRequestStructure::setAccountId()
     * @uses ContextualisedRequestStructure::setAccountKey()
     * @uses ContextualisedRequestStructure::setAddress()
     * @uses ContextualisedRequestStructure::setRequestorRef()
     * @uses ContextualisedRequestStructure::setMessageIdentifier()
     * @uses ContextualisedRequestStructure::setDelegatorAddress()
     * @uses ContextualisedRequestStructure::setDelegatorRef()
     * @param \StructType\ServiceRequestContextStructure $serviceRequestContext
     * @param string $requestTimestamp
     * @param string $accountId
     * @param string $accountKey
     * @param string $address
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct(\StructType\ServiceRequestContextStructure $serviceRequestContext = null, $requestTimestamp = null, $accountId = null, $accountKey = null, $address = null, \StructType\ParticipantRefStructure $requestorRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setServiceRequestContext($serviceRequestContext)
            ->setRequestTimestamp($requestTimestamp)
            ->setAccountId($accountId)
            ->setAccountKey($accountKey)
            ->setAddress($address)
            ->setRequestorRef($requestorRef)
            ->setMessageIdentifier($messageIdentifier)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get ServiceRequestContext value
     * @return \StructType\ServiceRequestContextStructure|null
     */
    public function getServiceRequestContext()
    {
        return $this->ServiceRequestContext;
    }
    /**
     * Set ServiceRequestContext value
     * @param \StructType\ServiceRequestContextStructure $serviceRequestContext
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setServiceRequestContext(\StructType\ServiceRequestContextStructure $serviceRequestContext = null)
    {
        $this->ServiceRequestContext = $serviceRequestContext;
        return $this;
    }
    /**
     * Get RequestTimestamp value
     * @return string|null
     */
    public function getRequestTimestamp()
    {
        return $this->RequestTimestamp;
    }
    /**
     * Set RequestTimestamp value
     * @param string $requestTimestamp
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setRequestTimestamp($requestTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($requestTimestamp) && !is_string($requestTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTimestamp)), __LINE__);
        }
        $this->RequestTimestamp = $requestTimestamp;
        return $this;
    }
    /**
     * Get AccountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AccountKey value
     * @return string|null
     */
    public function getAccountKey()
    {
        return $this->AccountKey;
    }
    /**
     * Set AccountKey value
     * @param string $accountKey
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setAccountKey($accountKey = null)
    {
        // validation for constraint: string
        if (!is_null($accountKey) && !is_string($accountKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountKey)), __LINE__);
        }
        $this->AccountKey = $accountKey;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RequestorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getRequestorRef()
    {
        return $this->RequestorRef;
    }
    /**
     * Set RequestorRef value
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setRequestorRef(\StructType\ParticipantRefStructure $requestorRef = null)
    {
        $this->RequestorRef = $requestorRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ContextualisedRequestStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContextualisedRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
