<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContextualisedConnectionLinkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Connection between two stops within a connection area. Used within the context of one or other end.
 * @subpackage Structs
 */
class ContextualisedConnectionLinkStructure extends AbstractStructBase
{
    /**
     * The ConnectionLinkCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of CONNECTION LINk. | Type for identifier of a CONNECTION link
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionLinkCode;
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The StopPointName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * The DefaultDuration
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $DefaultDuration;
    /**
     * The FrequentTravellerDuration
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $FrequentTravellerDuration;
    /**
     * The OccasionalTravellerDuration
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $OccasionalTravellerDuration;
    /**
     * The ImpairedAccessDuration
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ImpairedAccessDuration;
    /**
     * Constructor method for ContextualisedConnectionLinkStructure
     * @uses ContextualisedConnectionLinkStructure::setConnectionLinkCode()
     * @uses ContextualisedConnectionLinkStructure::setStopPointRef()
     * @uses ContextualisedConnectionLinkStructure::setStopPointName()
     * @uses ContextualisedConnectionLinkStructure::setDefaultDuration()
     * @uses ContextualisedConnectionLinkStructure::setFrequentTravellerDuration()
     * @uses ContextualisedConnectionLinkStructure::setOccasionalTravellerDuration()
     * @uses ContextualisedConnectionLinkStructure::setImpairedAccessDuration()
     * @param string $connectionLinkCode
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @param string $defaultDuration
     * @param string $frequentTravellerDuration
     * @param string $occasionalTravellerDuration
     * @param string $impairedAccessDuration
     */
    public function __construct($connectionLinkCode = null, \StructType\StopPointRefStructure $stopPointRef = null, \StructType\NaturalLanguageStringStructure $stopPointName = null, $defaultDuration = null, $frequentTravellerDuration = null, $occasionalTravellerDuration = null, $impairedAccessDuration = null)
    {
        $this
            ->setConnectionLinkCode($connectionLinkCode)
            ->setStopPointRef($stopPointRef)
            ->setStopPointName($stopPointName)
            ->setDefaultDuration($defaultDuration)
            ->setFrequentTravellerDuration($frequentTravellerDuration)
            ->setOccasionalTravellerDuration($occasionalTravellerDuration)
            ->setImpairedAccessDuration($impairedAccessDuration);
    }
    /**
     * Get ConnectionLinkCode value
     * @return string|null
     */
    public function getConnectionLinkCode()
    {
        return $this->ConnectionLinkCode;
    }
    /**
     * Set ConnectionLinkCode value
     * @param string $connectionLinkCode
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setConnectionLinkCode($connectionLinkCode = null)
    {
        // validation for constraint: string
        if (!is_null($connectionLinkCode) && !is_string($connectionLinkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionLinkCode)), __LINE__);
        }
        $this->ConnectionLinkCode = $connectionLinkCode;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Get DefaultDuration value
     * @return string|null
     */
    public function getDefaultDuration()
    {
        return $this->DefaultDuration;
    }
    /**
     * Set DefaultDuration value
     * @param string $defaultDuration
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setDefaultDuration($defaultDuration = null)
    {
        // validation for constraint: string
        if (!is_null($defaultDuration) && !is_string($defaultDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultDuration)), __LINE__);
        }
        $this->DefaultDuration = $defaultDuration;
        return $this;
    }
    /**
     * Get FrequentTravellerDuration value
     * @return string|null
     */
    public function getFrequentTravellerDuration()
    {
        return $this->FrequentTravellerDuration;
    }
    /**
     * Set FrequentTravellerDuration value
     * @param string $frequentTravellerDuration
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setFrequentTravellerDuration($frequentTravellerDuration = null)
    {
        // validation for constraint: string
        if (!is_null($frequentTravellerDuration) && !is_string($frequentTravellerDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequentTravellerDuration)), __LINE__);
        }
        $this->FrequentTravellerDuration = $frequentTravellerDuration;
        return $this;
    }
    /**
     * Get OccasionalTravellerDuration value
     * @return string|null
     */
    public function getOccasionalTravellerDuration()
    {
        return $this->OccasionalTravellerDuration;
    }
    /**
     * Set OccasionalTravellerDuration value
     * @param string $occasionalTravellerDuration
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setOccasionalTravellerDuration($occasionalTravellerDuration = null)
    {
        // validation for constraint: string
        if (!is_null($occasionalTravellerDuration) && !is_string($occasionalTravellerDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($occasionalTravellerDuration)), __LINE__);
        }
        $this->OccasionalTravellerDuration = $occasionalTravellerDuration;
        return $this;
    }
    /**
     * Get ImpairedAccessDuration value
     * @return string|null
     */
    public function getImpairedAccessDuration()
    {
        return $this->ImpairedAccessDuration;
    }
    /**
     * Set ImpairedAccessDuration value
     * @param string $impairedAccessDuration
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public function setImpairedAccessDuration($impairedAccessDuration = null)
    {
        // validation for constraint: string
        if (!is_null($impairedAccessDuration) && !is_string($impairedAccessDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($impairedAccessDuration)), __LINE__);
        }
        $this->ImpairedAccessDuration = $impairedAccessDuration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContextualisedConnectionLinkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
