<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionTimetablePermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Participant's permissions to use the service, Only returned if requested.
 * @subpackage Structs
 */
class ConnectionTimetablePermissions extends PermissionsStructure
{
    /**
     * The ConnectionTimetablePermission
     * Meta informations extracted from the WSDL
     * - documentation: Permission for a single participant or all participants to use an aspect of the service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConnectionServicePermissionStructure[]
     */
    public $ConnectionTimetablePermission;
    /**
     * Constructor method for ConnectionTimetablePermissions
     * @uses ConnectionTimetablePermissions::setConnectionTimetablePermission()
     * @param \StructType\ConnectionServicePermissionStructure[] $connectionTimetablePermission
     */
    public function __construct(array $connectionTimetablePermission = array())
    {
        $this
            ->setConnectionTimetablePermission($connectionTimetablePermission);
    }
    /**
     * Get ConnectionTimetablePermission value
     * @return \StructType\ConnectionServicePermissionStructure[]|null
     */
    public function getConnectionTimetablePermission()
    {
        return $this->ConnectionTimetablePermission;
    }
    /**
     * Set ConnectionTimetablePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionServicePermissionStructure[] $connectionTimetablePermission
     * @return \StructType\ConnectionTimetablePermissions
     */
    public function setConnectionTimetablePermission(array $connectionTimetablePermission = array())
    {
        foreach ($connectionTimetablePermission as $connectionTimetablePermissionsConnectionTimetablePermissionItem) {
            // validation for constraint: itemType
            if (!$connectionTimetablePermissionsConnectionTimetablePermissionItem instanceof \StructType\ConnectionServicePermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionTimetablePermission property can only contain items of \StructType\ConnectionServicePermissionStructure, "%s" given', is_object($connectionTimetablePermissionsConnectionTimetablePermissionItem) ? get_class($connectionTimetablePermissionsConnectionTimetablePermissionItem) : gettype($connectionTimetablePermissionsConnectionTimetablePermissionItem)), __LINE__);
            }
        }
        $this->ConnectionTimetablePermission = $connectionTimetablePermission;
        return $this;
    }
    /**
     * Add item to ConnectionTimetablePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionServicePermissionStructure $item
     * @return \StructType\ConnectionTimetablePermissions
     */
    public function addToConnectionTimetablePermission(\StructType\ConnectionServicePermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionServicePermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionTimetablePermission property can only contain items of \StructType\ConnectionServicePermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionTimetablePermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionTimetablePermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
