<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionTimetableDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Connection Protection.
 * @subpackage Structs
 */
class ConnectionTimetableDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The TimetabledFeederArrival
     * @var \StructType\TimetabledFeederArrivalStructure
     */
    public $TimetabledFeederArrival;
    /**
     * The TimetabledFeederArrivalCancellation
     * @var \StructType\TimetabledFeederArrivalCancellationStructure
     */
    public $TimetabledFeederArrivalCancellation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ConnectionTimetableDeliveryStructure
     * @uses ConnectionTimetableDeliveryStructure::setTimetabledFeederArrival()
     * @uses ConnectionTimetableDeliveryStructure::setTimetabledFeederArrivalCancellation()
     * @uses ConnectionTimetableDeliveryStructure::setExtensions()
     * @uses ConnectionTimetableDeliveryStructure::setVersion()
     * @param \StructType\TimetabledFeederArrivalStructure $timetabledFeederArrival
     * @param \StructType\TimetabledFeederArrivalCancellationStructure $timetabledFeederArrivalCancellation
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\TimetabledFeederArrivalStructure $timetabledFeederArrival = null, \StructType\TimetabledFeederArrivalCancellationStructure $timetabledFeederArrivalCancellation = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setTimetabledFeederArrival($timetabledFeederArrival)
            ->setTimetabledFeederArrivalCancellation($timetabledFeederArrivalCancellation)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get TimetabledFeederArrival value
     * @return \StructType\TimetabledFeederArrivalStructure|null
     */
    public function getTimetabledFeederArrival()
    {
        return $this->TimetabledFeederArrival;
    }
    /**
     * Set TimetabledFeederArrival value
     * @param \StructType\TimetabledFeederArrivalStructure $timetabledFeederArrival
     * @return \StructType\ConnectionTimetableDeliveryStructure
     */
    public function setTimetabledFeederArrival(\StructType\TimetabledFeederArrivalStructure $timetabledFeederArrival = null)
    {
        $this->TimetabledFeederArrival = $timetabledFeederArrival;
        return $this;
    }
    /**
     * Get TimetabledFeederArrivalCancellation value
     * @return \StructType\TimetabledFeederArrivalCancellationStructure|null
     */
    public function getTimetabledFeederArrivalCancellation()
    {
        return $this->TimetabledFeederArrivalCancellation;
    }
    /**
     * Set TimetabledFeederArrivalCancellation value
     * @param \StructType\TimetabledFeederArrivalCancellationStructure $timetabledFeederArrivalCancellation
     * @return \StructType\ConnectionTimetableDeliveryStructure
     */
    public function setTimetabledFeederArrivalCancellation(\StructType\TimetabledFeederArrivalCancellationStructure $timetabledFeederArrivalCancellation = null)
    {
        $this->TimetabledFeederArrivalCancellation = $timetabledFeederArrivalCancellation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionTimetableDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionTimetableDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionTimetableDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
