<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionServicePermissionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Monitoring Service Permission.
 * @subpackage Structs
 */
class ConnectionServicePermissionStructure extends AbstractPermissionStructure
{
    /**
     * The OperatorPermissions
     * Meta informations extracted from the WSDL
     * - ref: OperatorPermissions
     * @var \StructType\OperatorPermissions
     */
    public $OperatorPermissions;
    /**
     * The LinePermissions
     * Meta informations extracted from the WSDL
     * - ref: LinePermissions
     * @var \StructType\LinePermissions
     */
    public $LinePermissions;
    /**
     * The ConnectionLinkPermissions
     * Meta informations extracted from the WSDL
     * - ref: ConnectionLinkPermissions
     * @var \StructType\ConnectionLinkPermissions
     */
    public $ConnectionLinkPermissions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ConnectionServicePermissionStructure
     * @uses ConnectionServicePermissionStructure::setOperatorPermissions()
     * @uses ConnectionServicePermissionStructure::setLinePermissions()
     * @uses ConnectionServicePermissionStructure::setConnectionLinkPermissions()
     * @uses ConnectionServicePermissionStructure::setExtensions()
     * @param \StructType\OperatorPermissions $operatorPermissions
     * @param \StructType\LinePermissions $linePermissions
     * @param \StructType\ConnectionLinkPermissions $connectionLinkPermissions
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\OperatorPermissions $operatorPermissions = null, \StructType\LinePermissions $linePermissions = null, \StructType\ConnectionLinkPermissions $connectionLinkPermissions = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setOperatorPermissions($operatorPermissions)
            ->setLinePermissions($linePermissions)
            ->setConnectionLinkPermissions($connectionLinkPermissions)
            ->setExtensions($extensions);
    }
    /**
     * Get OperatorPermissions value
     * @return \StructType\OperatorPermissions|null
     */
    public function getOperatorPermissions()
    {
        return $this->OperatorPermissions;
    }
    /**
     * Set OperatorPermissions value
     * @param \StructType\OperatorPermissions $operatorPermissions
     * @return \StructType\ConnectionServicePermissionStructure
     */
    public function setOperatorPermissions(\StructType\OperatorPermissions $operatorPermissions = null)
    {
        $this->OperatorPermissions = $operatorPermissions;
        return $this;
    }
    /**
     * Get LinePermissions value
     * @return \StructType\LinePermissions|null
     */
    public function getLinePermissions()
    {
        return $this->LinePermissions;
    }
    /**
     * Set LinePermissions value
     * @param \StructType\LinePermissions $linePermissions
     * @return \StructType\ConnectionServicePermissionStructure
     */
    public function setLinePermissions(\StructType\LinePermissions $linePermissions = null)
    {
        $this->LinePermissions = $linePermissions;
        return $this;
    }
    /**
     * Get ConnectionLinkPermissions value
     * @return \StructType\ConnectionLinkPermissions|null
     */
    public function getConnectionLinkPermissions()
    {
        return $this->ConnectionLinkPermissions;
    }
    /**
     * Set ConnectionLinkPermissions value
     * @param \StructType\ConnectionLinkPermissions $connectionLinkPermissions
     * @return \StructType\ConnectionServicePermissionStructure
     */
    public function setConnectionLinkPermissions(\StructType\ConnectionLinkPermissions $connectionLinkPermissions = null)
    {
        $this->ConnectionLinkPermissions = $connectionLinkPermissions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionServicePermissionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionServicePermissionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
