<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringSubscriptionRequestStructure
 * StructType
 * Meta informations extracted from the WSDL
 * - documentation: Subscription Request for Connection Monitoring.
 * @subpackage Structs
 */
class ConnectionMonitoringSubscriptionRequestStructure extends AbstractSubscriptionStructure
{
    /**
     * The ConnectionMonitoringRequest
     * Meta informations extracted from the WSDL
     * - ref: ConnectionMonitoringRequest
     * @var \StructType\ConnectionMonitoringRequestStructure
     */
    public $ConnectionMonitoringRequest;
    /**
     * The ChangeBeforeUpdates
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ChangeBeforeUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ConnectionMonitoringSubscriptionRequestStructure
     * @uses ConnectionMonitoringSubscriptionRequestStructure::setConnectionMonitoringRequest()
     * @uses ConnectionMonitoringSubscriptionRequestStructure::setChangeBeforeUpdates()
     * @uses ConnectionMonitoringSubscriptionRequestStructure::setExtensions()
     * @param \StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest
     * @param string $changeBeforeUpdates
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest = null, $changeBeforeUpdates = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setConnectionMonitoringRequest($connectionMonitoringRequest)
            ->setChangeBeforeUpdates($changeBeforeUpdates)
            ->setExtensions($extensions);
    }
    /**
     * Get ConnectionMonitoringRequest value
     * @return \StructType\ConnectionMonitoringRequestStructure|null
     */
    public function getConnectionMonitoringRequest()
    {
        return $this->ConnectionMonitoringRequest;
    }
    /**
     * Set ConnectionMonitoringRequest value
     * @param \StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest
     * @return \StructType\ConnectionMonitoringSubscriptionRequestStructure
     */
    public function setConnectionMonitoringRequest(\StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest = null)
    {
        $this->ConnectionMonitoringRequest = $connectionMonitoringRequest;
        return $this;
    }
    /**
     * Get ChangeBeforeUpdates value
     * @return string|null
     */
    public function getChangeBeforeUpdates()
    {
        return $this->ChangeBeforeUpdates;
    }
    /**
     * Set ChangeBeforeUpdates value
     * @param string $changeBeforeUpdates
     * @return \StructType\ConnectionMonitoringSubscriptionRequestStructure
     */
    public function setChangeBeforeUpdates($changeBeforeUpdates = null)
    {
        // validation for constraint: string
        if (!is_null($changeBeforeUpdates) && !is_string($changeBeforeUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeBeforeUpdates)), __LINE__);
        }
        $this->ChangeBeforeUpdates = $changeBeforeUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionMonitoringSubscriptionRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringSubscriptionRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
