<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringDeliveriesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Deliveries for Connection Monitoring Service. Used in WSDL. | Delivery for Connection Protection Feeder Service. | Delivery for Connection Protection Distributor i.e. Fetcher Service.
 * @subpackage Structs
 */
class ConnectionMonitoringDeliveriesStructure extends AbstractStructBase
{
    /**
     * The ConnectionMonitoringFeederDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ConnectionMonitoringFeederDelivery
     * @var \StructType\ConnectionMonitoringFeederDeliveryStructure[]
     */
    public $ConnectionMonitoringFeederDelivery;
    /**
     * The ConnectionMonitoringDistributorDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ConnectionMonitoringDistributorDelivery
     * @var \StructType\ConnectionMonitoringDistributorDeliveryStructure[]
     */
    public $ConnectionMonitoringDistributorDelivery;
    /**
     * Constructor method for ConnectionMonitoringDeliveriesStructure
     * @uses ConnectionMonitoringDeliveriesStructure::setConnectionMonitoringFeederDelivery()
     * @uses ConnectionMonitoringDeliveriesStructure::setConnectionMonitoringDistributorDelivery()
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure[] $connectionMonitoringFeederDelivery
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure[] $connectionMonitoringDistributorDelivery
     */
    public function __construct(array $connectionMonitoringFeederDelivery = array(), array $connectionMonitoringDistributorDelivery = array())
    {
        $this
            ->setConnectionMonitoringFeederDelivery($connectionMonitoringFeederDelivery)
            ->setConnectionMonitoringDistributorDelivery($connectionMonitoringDistributorDelivery);
    }
    /**
     * Get ConnectionMonitoringFeederDelivery value
     * @return \StructType\ConnectionMonitoringFeederDeliveryStructure[]|null
     */
    public function getConnectionMonitoringFeederDelivery()
    {
        return $this->ConnectionMonitoringFeederDelivery;
    }
    /**
     * Set ConnectionMonitoringFeederDelivery value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure[] $connectionMonitoringFeederDelivery
     * @return \StructType\ConnectionMonitoringDeliveriesStructure
     */
    public function setConnectionMonitoringFeederDelivery(array $connectionMonitoringFeederDelivery = array())
    {
        foreach ($connectionMonitoringFeederDelivery as $connectionMonitoringDeliveriesStructureConnectionMonitoringFeederDeliveryItem) {
            // validation for constraint: itemType
            if (!$connectionMonitoringDeliveriesStructureConnectionMonitoringFeederDeliveryItem instanceof \StructType\ConnectionMonitoringFeederDeliveryStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionMonitoringFeederDelivery property can only contain items of \StructType\ConnectionMonitoringFeederDeliveryStructure, "%s" given', is_object($connectionMonitoringDeliveriesStructureConnectionMonitoringFeederDeliveryItem) ? get_class($connectionMonitoringDeliveriesStructureConnectionMonitoringFeederDeliveryItem) : gettype($connectionMonitoringDeliveriesStructureConnectionMonitoringFeederDeliveryItem)), __LINE__);
            }
        }
        $this->ConnectionMonitoringFeederDelivery = $connectionMonitoringFeederDelivery;
        return $this;
    }
    /**
     * Add item to ConnectionMonitoringFeederDelivery value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionMonitoringFeederDeliveryStructure $item
     * @return \StructType\ConnectionMonitoringDeliveriesStructure
     */
    public function addToConnectionMonitoringFeederDelivery(\StructType\ConnectionMonitoringFeederDeliveryStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionMonitoringFeederDeliveryStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionMonitoringFeederDelivery property can only contain items of \StructType\ConnectionMonitoringFeederDeliveryStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionMonitoringFeederDelivery[] = $item;
        return $this;
    }
    /**
     * Get ConnectionMonitoringDistributorDelivery value
     * @return \StructType\ConnectionMonitoringDistributorDeliveryStructure[]|null
     */
    public function getConnectionMonitoringDistributorDelivery()
    {
        return $this->ConnectionMonitoringDistributorDelivery;
    }
    /**
     * Set ConnectionMonitoringDistributorDelivery value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure[] $connectionMonitoringDistributorDelivery
     * @return \StructType\ConnectionMonitoringDeliveriesStructure
     */
    public function setConnectionMonitoringDistributorDelivery(array $connectionMonitoringDistributorDelivery = array())
    {
        foreach ($connectionMonitoringDistributorDelivery as $connectionMonitoringDeliveriesStructureConnectionMonitoringDistributorDeliveryItem) {
            // validation for constraint: itemType
            if (!$connectionMonitoringDeliveriesStructureConnectionMonitoringDistributorDeliveryItem instanceof \StructType\ConnectionMonitoringDistributorDeliveryStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionMonitoringDistributorDelivery property can only contain items of \StructType\ConnectionMonitoringDistributorDeliveryStructure, "%s" given', is_object($connectionMonitoringDeliveriesStructureConnectionMonitoringDistributorDeliveryItem) ? get_class($connectionMonitoringDeliveriesStructureConnectionMonitoringDistributorDeliveryItem) : gettype($connectionMonitoringDeliveriesStructureConnectionMonitoringDistributorDeliveryItem)), __LINE__);
            }
        }
        $this->ConnectionMonitoringDistributorDelivery = $connectionMonitoringDistributorDelivery;
        return $this;
    }
    /**
     * Add item to ConnectionMonitoringDistributorDelivery value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionMonitoringDistributorDeliveryStructure $item
     * @return \StructType\ConnectionMonitoringDeliveriesStructure
     */
    public function addToConnectionMonitoringDistributorDelivery(\StructType\ConnectionMonitoringDistributorDeliveryStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionMonitoringDistributorDeliveryStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionMonitoringDistributorDelivery property can only contain items of \StructType\ConnectionMonitoringDistributorDeliveryStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionMonitoringDistributorDelivery[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringDeliveriesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
