<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionMonitoringCapabilitiesResponseStructure
 * StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delivery for Connection Monitoring Capability.
 * @subpackage Structs
 */
class ConnectionMonitoringCapabilitiesResponseStructure extends AbstractServiceCapabilitiesResponseStructure
{
    /**
     * The ConnectionMonitoringServiceCapabilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ConnectionMonitoringServiceCapabilities
     * @var \StructType\ConnectionMonitoringServiceCapabilitiesStructure
     */
    public $ConnectionMonitoringServiceCapabilities;
    /**
     * The ConnectionMonitoringPermissions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ConnectionMonitoringPermissions
     * @var \StructType\ConnectionMonitoringPermissions
     */
    public $ConnectionMonitoringPermissions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ConnectionMonitoringCapabilitiesResponseStructure
     * @uses ConnectionMonitoringCapabilitiesResponseStructure::setConnectionMonitoringServiceCapabilities()
     * @uses ConnectionMonitoringCapabilitiesResponseStructure::setConnectionMonitoringPermissions()
     * @uses ConnectionMonitoringCapabilitiesResponseStructure::setExtensions()
     * @uses ConnectionMonitoringCapabilitiesResponseStructure::setVersion()
     * @param \StructType\ConnectionMonitoringServiceCapabilitiesStructure $connectionMonitoringServiceCapabilities
     * @param \StructType\ConnectionMonitoringPermissions $connectionMonitoringPermissions
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\ConnectionMonitoringServiceCapabilitiesStructure $connectionMonitoringServiceCapabilities = null, \StructType\ConnectionMonitoringPermissions $connectionMonitoringPermissions = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setConnectionMonitoringServiceCapabilities($connectionMonitoringServiceCapabilities)
            ->setConnectionMonitoringPermissions($connectionMonitoringPermissions)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get ConnectionMonitoringServiceCapabilities value
     * @return \StructType\ConnectionMonitoringServiceCapabilitiesStructure|null
     */
    public function getConnectionMonitoringServiceCapabilities()
    {
        return $this->ConnectionMonitoringServiceCapabilities;
    }
    /**
     * Set ConnectionMonitoringServiceCapabilities value
     * @param \StructType\ConnectionMonitoringServiceCapabilitiesStructure $connectionMonitoringServiceCapabilities
     * @return \StructType\ConnectionMonitoringCapabilitiesResponseStructure
     */
    public function setConnectionMonitoringServiceCapabilities(\StructType\ConnectionMonitoringServiceCapabilitiesStructure $connectionMonitoringServiceCapabilities = null)
    {
        $this->ConnectionMonitoringServiceCapabilities = $connectionMonitoringServiceCapabilities;
        return $this;
    }
    /**
     * Get ConnectionMonitoringPermissions value
     * @return \StructType\ConnectionMonitoringPermissions|null
     */
    public function getConnectionMonitoringPermissions()
    {
        return $this->ConnectionMonitoringPermissions;
    }
    /**
     * Set ConnectionMonitoringPermissions value
     * @param \StructType\ConnectionMonitoringPermissions $connectionMonitoringPermissions
     * @return \StructType\ConnectionMonitoringCapabilitiesResponseStructure
     */
    public function setConnectionMonitoringPermissions(\StructType\ConnectionMonitoringPermissions $connectionMonitoringPermissions = null)
    {
        $this->ConnectionMonitoringPermissions = $connectionMonitoringPermissions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionMonitoringCapabilitiesResponseStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionMonitoringCapabilitiesResponseStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionMonitoringCapabilitiesResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
