<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLinksDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response with CONNECTION LINKs available to make requests. +SIR v2.0
 * @subpackage Structs
 */
class ConnectionLinksDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * - fixed: 2.0
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The AnnotatedConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: AnnotatedConnectionLinkRef
     * @var \StructType\AnnotatedConnectionLinkStructure[]
     */
    public $AnnotatedConnectionLinkRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for ConnectionLinksDeliveryStructure
     * @uses ConnectionLinksDeliveryStructure::setVersion()
     * @uses ConnectionLinksDeliveryStructure::setAnnotatedConnectionLinkRef()
     * @uses ConnectionLinksDeliveryStructure::setExtensions()
     * @param string $version
     * @param \StructType\AnnotatedConnectionLinkStructure[] $annotatedConnectionLinkRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($version = null, array $annotatedConnectionLinkRef = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVersion($version)
            ->setAnnotatedConnectionLinkRef($annotatedConnectionLinkRef)
            ->setExtensions($extensions);
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ConnectionLinksDeliveryStructure
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get AnnotatedConnectionLinkRef value
     * @return \StructType\AnnotatedConnectionLinkStructure[]|null
     */
    public function getAnnotatedConnectionLinkRef()
    {
        return $this->AnnotatedConnectionLinkRef;
    }
    /**
     * Set AnnotatedConnectionLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedConnectionLinkStructure[] $annotatedConnectionLinkRef
     * @return \StructType\ConnectionLinksDeliveryStructure
     */
    public function setAnnotatedConnectionLinkRef(array $annotatedConnectionLinkRef = array())
    {
        foreach ($annotatedConnectionLinkRef as $connectionLinksDeliveryStructureAnnotatedConnectionLinkRefItem) {
            // validation for constraint: itemType
            if (!$connectionLinksDeliveryStructureAnnotatedConnectionLinkRefItem instanceof \StructType\AnnotatedConnectionLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The AnnotatedConnectionLinkRef property can only contain items of \StructType\AnnotatedConnectionLinkStructure, "%s" given', is_object($connectionLinksDeliveryStructureAnnotatedConnectionLinkRefItem) ? get_class($connectionLinksDeliveryStructureAnnotatedConnectionLinkRefItem) : gettype($connectionLinksDeliveryStructureAnnotatedConnectionLinkRefItem)), __LINE__);
            }
        }
        $this->AnnotatedConnectionLinkRef = $annotatedConnectionLinkRef;
        return $this;
    }
    /**
     * Add item to AnnotatedConnectionLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedConnectionLinkStructure $item
     * @return \StructType\ConnectionLinksDeliveryStructure
     */
    public function addToAnnotatedConnectionLinkRef(\StructType\AnnotatedConnectionLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnnotatedConnectionLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The AnnotatedConnectionLinkRef property can only contain items of \StructType\AnnotatedConnectionLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnnotatedConnectionLinkRef[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ConnectionLinksDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLinksDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
