<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLinks StructType
 * Meta informations extracted from the WSDL
 * - documentation: CONNECTION links from stop.
 * @subpackage Structs
 */
class ConnectionLinks extends AbstractStructBase
{
    /**
     * The AffectedConnectionLink
     * Meta informations extracted from the WSDL
     * - documentation: CONNECTION LINKs from stop that are affected by the SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedConnectionLinkStructure[]
     */
    public $AffectedConnectionLink;
    /**
     * Constructor method for ConnectionLinks
     * @uses ConnectionLinks::setAffectedConnectionLink()
     * @param \StructType\AffectedConnectionLinkStructure[] $affectedConnectionLink
     */
    public function __construct(array $affectedConnectionLink = array())
    {
        $this
            ->setAffectedConnectionLink($affectedConnectionLink);
    }
    /**
     * Get AffectedConnectionLink value
     * @return \StructType\AffectedConnectionLinkStructure[]|null
     */
    public function getAffectedConnectionLink()
    {
        return $this->AffectedConnectionLink;
    }
    /**
     * Set AffectedConnectionLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedConnectionLinkStructure[] $affectedConnectionLink
     * @return \StructType\ConnectionLinks
     */
    public function setAffectedConnectionLink(array $affectedConnectionLink = array())
    {
        foreach ($affectedConnectionLink as $connectionLinksAffectedConnectionLinkItem) {
            // validation for constraint: itemType
            if (!$connectionLinksAffectedConnectionLinkItem instanceof \StructType\AffectedConnectionLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedConnectionLink property can only contain items of \StructType\AffectedConnectionLinkStructure, "%s" given', is_object($connectionLinksAffectedConnectionLinkItem) ? get_class($connectionLinksAffectedConnectionLinkItem) : gettype($connectionLinksAffectedConnectionLinkItem)), __LINE__);
            }
        }
        $this->AffectedConnectionLink = $affectedConnectionLink;
        return $this;
    }
    /**
     * Add item to AffectedConnectionLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedConnectionLinkStructure $item
     * @return \StructType\ConnectionLinks
     */
    public function addToAffectedConnectionLink(\StructType\AffectedConnectionLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedConnectionLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedConnectionLink property can only contain items of \StructType\AffectedConnectionLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedConnectionLink[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLinks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
