<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @subpackage Structs
 */
class Comment extends AbstractStructBase
{
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MultilingualString
     */
    public $comment;
    /**
     * The commentDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commentDateTime;
    /**
     * The commentExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $commentExtension;
    /**
     * Constructor method for Comment
     * @uses Comment::setComment()
     * @uses Comment::setCommentDateTime()
     * @uses Comment::setCommentExtension()
     * @param \StructType\MultilingualString $comment
     * @param string $commentDateTime
     * @param \StructType\ExtensionType $commentExtension
     */
    public function __construct(\StructType\MultilingualString $comment = null, $commentDateTime = null, \StructType\ExtensionType $commentExtension = null)
    {
        $this
            ->setComment($comment)
            ->setCommentDateTime($commentDateTime)
            ->setCommentExtension($commentExtension);
    }
    /**
     * Get comment value
     * @return \StructType\MultilingualString
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param \StructType\MultilingualString $comment
     * @return \StructType\Comment
     */
    public function setComment(\StructType\MultilingualString $comment = null)
    {
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get commentDateTime value
     * @return string|null
     */
    public function getCommentDateTime()
    {
        return $this->commentDateTime;
    }
    /**
     * Set commentDateTime value
     * @param string $commentDateTime
     * @return \StructType\Comment
     */
    public function setCommentDateTime($commentDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($commentDateTime) && !is_string($commentDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentDateTime)), __LINE__);
        }
        $this->commentDateTime = $commentDateTime;
        return $this;
    }
    /**
     * Get commentExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getCommentExtension()
    {
        return $this->commentExtension;
    }
    /**
     * Set commentExtension value
     * @param \StructType\ExtensionType $commentExtension
     * @return \StructType\Comment
     */
    public function setCommentExtension(\StructType\ExtensionType $commentExtension = null)
    {
        $this->commentExtension = $commentExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Comment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
