<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckPointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a CHECK CONSTRAINT Hazard that can be associated with.
 * @subpackage Structs
 */
class CheckPointStructure extends AbstractStructBase
{
    /**
     * The CheckPointId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of CHECK CONSTRAINt. | Type for identifier of a CHECK CONSTRAINT.within a STOP PLACE.
     * - minOccurs: 0
     * @var string
     */
    public $CheckPointId;
    /**
     * The ValidityCondition
     * @var \StructType\ValidityConditionStructure
     */
    public $ValidityCondition;
    /**
     * The CheckPointProcess
     * @var string
     */
    public $CheckPointProcess;
    /**
     * The CheckPointService
     * @var string
     */
    public $CheckPointService;
    /**
     * The AccessFeatureType
     * @var string
     */
    public $AccessFeatureType;
    /**
     * The Congestion
     * @var string
     */
    public $Congestion;
    /**
     * The FacilityRef
     * @var string
     */
    public $FacilityRef;
    /**
     * The MinimumLikelyDelay
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $MinimumLikelyDelay;
    /**
     * The AverageDelay
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AverageDelay;
    /**
     * The MaximumLikelyDelay
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S",
     * "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $MaximumLikelyDelay;
    /**
     * Constructor method for CheckPointStructure
     * @uses CheckPointStructure::setCheckPointId()
     * @uses CheckPointStructure::setValidityCondition()
     * @uses CheckPointStructure::setCheckPointProcess()
     * @uses CheckPointStructure::setCheckPointService()
     * @uses CheckPointStructure::setAccessFeatureType()
     * @uses CheckPointStructure::setCongestion()
     * @uses CheckPointStructure::setFacilityRef()
     * @uses CheckPointStructure::setMinimumLikelyDelay()
     * @uses CheckPointStructure::setAverageDelay()
     * @uses CheckPointStructure::setMaximumLikelyDelay()
     * @param string $checkPointId
     * @param \StructType\ValidityConditionStructure $validityCondition
     * @param string $checkPointProcess
     * @param string $checkPointService
     * @param string $accessFeatureType
     * @param string $congestion
     * @param string $facilityRef
     * @param string $minimumLikelyDelay
     * @param string $averageDelay
     * @param string $maximumLikelyDelay
     */
    public function __construct($checkPointId = null, \StructType\ValidityConditionStructure $validityCondition = null, $checkPointProcess = null, $checkPointService = null, $accessFeatureType = null, $congestion = null, $facilityRef = null, $minimumLikelyDelay = null, $averageDelay = null, $maximumLikelyDelay = null)
    {
        $this
            ->setCheckPointId($checkPointId)
            ->setValidityCondition($validityCondition)
            ->setCheckPointProcess($checkPointProcess)
            ->setCheckPointService($checkPointService)
            ->setAccessFeatureType($accessFeatureType)
            ->setCongestion($congestion)
            ->setFacilityRef($facilityRef)
            ->setMinimumLikelyDelay($minimumLikelyDelay)
            ->setAverageDelay($averageDelay)
            ->setMaximumLikelyDelay($maximumLikelyDelay);
    }
    /**
     * Get CheckPointId value
     * @return string|null
     */
    public function getCheckPointId()
    {
        return $this->CheckPointId;
    }
    /**
     * Set CheckPointId value
     * @param string $checkPointId
     * @return \StructType\CheckPointStructure
     */
    public function setCheckPointId($checkPointId = null)
    {
        // validation for constraint: string
        if (!is_null($checkPointId) && !is_string($checkPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkPointId)), __LINE__);
        }
        $this->CheckPointId = $checkPointId;
        return $this;
    }
    /**
     * Get ValidityCondition value
     * @return \StructType\ValidityConditionStructure|null
     */
    public function getValidityCondition()
    {
        return $this->ValidityCondition;
    }
    /**
     * Set ValidityCondition value
     * @param \StructType\ValidityConditionStructure $validityCondition
     * @return \StructType\CheckPointStructure
     */
    public function setValidityCondition(\StructType\ValidityConditionStructure $validityCondition = null)
    {
        $this->ValidityCondition = $validityCondition;
        return $this;
    }
    /**
     * Get CheckPointProcess value
     * @return string|null
     */
    public function getCheckPointProcess()
    {
        return $this->CheckPointProcess;
    }
    /**
     * Set CheckPointProcess value
     * @uses \EnumType\CheckPointProcessEnumeration::valueIsValid()
     * @uses \EnumType\CheckPointProcessEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkPointProcess
     * @return \StructType\CheckPointStructure
     */
    public function setCheckPointProcess($checkPointProcess = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CheckPointProcessEnumeration::valueIsValid($checkPointProcess)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $checkPointProcess, implode(', ', \EnumType\CheckPointProcessEnumeration::getValidValues())), __LINE__);
        }
        $this->CheckPointProcess = $checkPointProcess;
        return $this;
    }
    /**
     * Get CheckPointService value
     * @return string|null
     */
    public function getCheckPointService()
    {
        return $this->CheckPointService;
    }
    /**
     * Set CheckPointService value
     * @uses \EnumType\CheckPointServiceEnumeration::valueIsValid()
     * @uses \EnumType\CheckPointServiceEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkPointService
     * @return \StructType\CheckPointStructure
     */
    public function setCheckPointService($checkPointService = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CheckPointServiceEnumeration::valueIsValid($checkPointService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $checkPointService, implode(', ', \EnumType\CheckPointServiceEnumeration::getValidValues())), __LINE__);
        }
        $this->CheckPointService = $checkPointService;
        return $this;
    }
    /**
     * Get AccessFeatureType value
     * @return string|null
     */
    public function getAccessFeatureType()
    {
        return $this->AccessFeatureType;
    }
    /**
     * Set AccessFeatureType value
     * @uses \EnumType\AccessibilityFeatureEnumeration::valueIsValid()
     * @uses \EnumType\AccessibilityFeatureEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessFeatureType
     * @return \StructType\CheckPointStructure
     */
    public function setAccessFeatureType($accessFeatureType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessibilityFeatureEnumeration::valueIsValid($accessFeatureType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessFeatureType, implode(', ', \EnumType\AccessibilityFeatureEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessFeatureType = $accessFeatureType;
        return $this;
    }
    /**
     * Get Congestion value
     * @return string|null
     */
    public function getCongestion()
    {
        return $this->Congestion;
    }
    /**
     * Set Congestion value
     * @uses \EnumType\CongestionEnumeration::valueIsValid()
     * @uses \EnumType\CongestionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $congestion
     * @return \StructType\CheckPointStructure
     */
    public function setCongestion($congestion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CongestionEnumeration::valueIsValid($congestion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $congestion, implode(', ', \EnumType\CongestionEnumeration::getValidValues())), __LINE__);
        }
        $this->Congestion = $congestion;
        return $this;
    }
    /**
     * Get FacilityRef value
     * @return string|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param string $facilityRef
     * @return \StructType\CheckPointStructure
     */
    public function setFacilityRef($facilityRef = null)
    {
        // validation for constraint: string
        if (!is_null($facilityRef) && !is_string($facilityRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facilityRef)), __LINE__);
        }
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get MinimumLikelyDelay value
     * @return string|null
     */
    public function getMinimumLikelyDelay()
    {
        return $this->MinimumLikelyDelay;
    }
    /**
     * Set MinimumLikelyDelay value
     * @param string $minimumLikelyDelay
     * @return \StructType\CheckPointStructure
     */
    public function setMinimumLikelyDelay($minimumLikelyDelay = null)
    {
        // validation for constraint: string
        if (!is_null($minimumLikelyDelay) && !is_string($minimumLikelyDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumLikelyDelay)), __LINE__);
        }
        $this->MinimumLikelyDelay = $minimumLikelyDelay;
        return $this;
    }
    /**
     * Get AverageDelay value
     * @return string|null
     */
    public function getAverageDelay()
    {
        return $this->AverageDelay;
    }
    /**
     * Set AverageDelay value
     * @param string $averageDelay
     * @return \StructType\CheckPointStructure
     */
    public function setAverageDelay($averageDelay = null)
    {
        // validation for constraint: string
        if (!is_null($averageDelay) && !is_string($averageDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($averageDelay)), __LINE__);
        }
        $this->AverageDelay = $averageDelay;
        return $this;
    }
    /**
     * Get MaximumLikelyDelay value
     * @return string|null
     */
    public function getMaximumLikelyDelay()
    {
        return $this->MaximumLikelyDelay;
    }
    /**
     * Set MaximumLikelyDelay value
     * @param string $maximumLikelyDelay
     * @return \StructType\CheckPointStructure
     */
    public function setMaximumLikelyDelay($maximumLikelyDelay = null)
    {
        // validation for constraint: string
        if (!is_null($maximumLikelyDelay) && !is_string($maximumLikelyDelay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumLikelyDelay)), __LINE__);
        }
        $this->MaximumLikelyDelay = $maximumLikelyDelay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckPointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
