<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapabilitySubscriptionPolicyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Common Subscription capabilities.
 * @subpackage Structs
 */
class CapabilitySubscriptionPolicyStructure extends AbstractStructBase
{
    /**
     * The HasIncrementalUpdates
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether incremental updates can be specified for updates Default is ' true'.
     * - minOccurs: 0
     * @var bool
     */
    public $HasIncrementalUpdates;
    /**
     * The HasChangeSensitivity
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether change threshold can be specified for updates. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $HasChangeSensitivity;
    /**
     * Constructor method for CapabilitySubscriptionPolicyStructure
     * @uses CapabilitySubscriptionPolicyStructure::setHasIncrementalUpdates()
     * @uses CapabilitySubscriptionPolicyStructure::setHasChangeSensitivity()
     * @param bool $hasIncrementalUpdates
     * @param bool $hasChangeSensitivity
     */
    public function __construct($hasIncrementalUpdates = true, $hasChangeSensitivity = true)
    {
        $this
            ->setHasIncrementalUpdates($hasIncrementalUpdates)
            ->setHasChangeSensitivity($hasChangeSensitivity);
    }
    /**
     * Get HasIncrementalUpdates value
     * @return bool|null
     */
    public function getHasIncrementalUpdates()
    {
        return $this->HasIncrementalUpdates;
    }
    /**
     * Set HasIncrementalUpdates value
     * @param bool $hasIncrementalUpdates
     * @return \StructType\CapabilitySubscriptionPolicyStructure
     */
    public function setHasIncrementalUpdates($hasIncrementalUpdates = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasIncrementalUpdates) && !is_bool($hasIncrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasIncrementalUpdates)), __LINE__);
        }
        $this->HasIncrementalUpdates = $hasIncrementalUpdates;
        return $this;
    }
    /**
     * Get HasChangeSensitivity value
     * @return bool|null
     */
    public function getHasChangeSensitivity()
    {
        return $this->HasChangeSensitivity;
    }
    /**
     * Set HasChangeSensitivity value
     * @param bool $hasChangeSensitivity
     * @return \StructType\CapabilitySubscriptionPolicyStructure
     */
    public function setHasChangeSensitivity($hasChangeSensitivity = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasChangeSensitivity) && !is_bool($hasChangeSensitivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasChangeSensitivity)), __LINE__);
        }
        $this->HasChangeSensitivity = $hasChangeSensitivity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CapabilitySubscriptionPolicyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
