<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapabilityAccessControlStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Common Access control capabilities.
 * @subpackage Structs
 */
class CapabilityAccessControlStructure extends AbstractStructBase
{
    /**
     * The RequestChecking
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether access control of requests is supported. Default is 'false'.
     * @var bool
     */
    public $RequestChecking;
    /**
     * Constructor method for CapabilityAccessControlStructure
     * @uses CapabilityAccessControlStructure::setRequestChecking()
     * @param bool $requestChecking
     */
    public function __construct($requestChecking = false)
    {
        $this
            ->setRequestChecking($requestChecking);
    }
    /**
     * Get RequestChecking value
     * @return bool|null
     */
    public function getRequestChecking()
    {
        return $this->RequestChecking;
    }
    /**
     * Set RequestChecking value
     * @param bool $requestChecking
     * @return \StructType\CapabilityAccessControlStructure
     */
    public function setRequestChecking($requestChecking = false)
    {
        // validation for constraint: boolean
        if (!is_null($requestChecking) && !is_bool($requestChecking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestChecking)), __LINE__);
        }
        $this->RequestChecking = $requestChecking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CapabilityAccessControlStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
