<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Boundary StructType
 * Meta informations extracted from the WSDL
 * - documentation: Boundary line of Zone as an ordered set of points.
 * @subpackage Structs
 */
class Boundary extends AbstractStructBase
{
    /**
     * The PointProjection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 3
     * - ref: PointProjection
     * @var \StructType\PointProjectionStructure[]
     */
    public $PointProjection;
    /**
     * Constructor method for Boundary
     * @uses Boundary::setPointProjection()
     * @param \StructType\PointProjectionStructure[] $pointProjection
     */
    public function __construct(array $pointProjection = array())
    {
        $this
            ->setPointProjection($pointProjection);
    }
    /**
     * Get PointProjection value
     * @return \StructType\PointProjectionStructure[]
     */
    public function getPointProjection()
    {
        return $this->PointProjection;
    }
    /**
     * Set PointProjection value
     * @throws \InvalidArgumentException
     * @param \StructType\PointProjectionStructure[] $pointProjection
     * @return \StructType\Boundary
     */
    public function setPointProjection(array $pointProjection = array())
    {
        foreach ($pointProjection as $boundaryPointProjectionItem) {
            // validation for constraint: itemType
            if (!$boundaryPointProjectionItem instanceof \StructType\PointProjectionStructure) {
                throw new \InvalidArgumentException(sprintf('The PointProjection property can only contain items of \StructType\PointProjectionStructure, "%s" given', is_object($boundaryPointProjectionItem) ? get_class($boundaryPointProjectionItem) : gettype($boundaryPointProjectionItem)), __LINE__);
            }
        }
        $this->PointProjection = $pointProjection;
        return $this;
    }
    /**
     * Add item to PointProjection value
     * @throws \InvalidArgumentException
     * @param \StructType\PointProjectionStructure $item
     * @return \StructType\Boundary
     */
    public function addToPointProjection(\StructType\PointProjectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PointProjectionStructure) {
            throw new \InvalidArgumentException(sprintf('The PointProjection property can only contain items of \StructType\PointProjectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PointProjection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Boundary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
