<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxleWeight StructType
 * @subpackage Structs
 */
class AxleWeight extends AbstractStructBase
{
    /**
     * The axlePositionIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $axlePositionIdentifier;
    /**
     * The axleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $axleWeight;
    /**
     * The maximumPermittedAxleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $maximumPermittedAxleWeight;
    /**
     * The axleWeightExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $axleWeightExtension;
    /**
     * Constructor method for AxleWeight
     * @uses AxleWeight::setAxlePositionIdentifier()
     * @uses AxleWeight::setAxleWeight()
     * @uses AxleWeight::setMaximumPermittedAxleWeight()
     * @uses AxleWeight::setAxleWeightExtension()
     * @param int $axlePositionIdentifier
     * @param float $axleWeight
     * @param float $maximumPermittedAxleWeight
     * @param \StructType\ExtensionType $axleWeightExtension
     */
    public function __construct($axlePositionIdentifier = null, $axleWeight = null, $maximumPermittedAxleWeight = null, \StructType\ExtensionType $axleWeightExtension = null)
    {
        $this
            ->setAxlePositionIdentifier($axlePositionIdentifier)
            ->setAxleWeight($axleWeight)
            ->setMaximumPermittedAxleWeight($maximumPermittedAxleWeight)
            ->setAxleWeightExtension($axleWeightExtension);
    }
    /**
     * Get axlePositionIdentifier value
     * @return int
     */
    public function getAxlePositionIdentifier()
    {
        return $this->axlePositionIdentifier;
    }
    /**
     * Set axlePositionIdentifier value
     * @param int $axlePositionIdentifier
     * @return \StructType\AxleWeight
     */
    public function setAxlePositionIdentifier($axlePositionIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($axlePositionIdentifier) && !is_numeric($axlePositionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($axlePositionIdentifier)), __LINE__);
        }
        $this->axlePositionIdentifier = $axlePositionIdentifier;
        return $this;
    }
    /**
     * Get axleWeight value
     * @return float|null
     */
    public function getAxleWeight()
    {
        return $this->axleWeight;
    }
    /**
     * Set axleWeight value
     * @param float $axleWeight
     * @return \StructType\AxleWeight
     */
    public function setAxleWeight($axleWeight = null)
    {
        $this->axleWeight = $axleWeight;
        return $this;
    }
    /**
     * Get maximumPermittedAxleWeight value
     * @return float|null
     */
    public function getMaximumPermittedAxleWeight()
    {
        return $this->maximumPermittedAxleWeight;
    }
    /**
     * Set maximumPermittedAxleWeight value
     * @param float $maximumPermittedAxleWeight
     * @return \StructType\AxleWeight
     */
    public function setMaximumPermittedAxleWeight($maximumPermittedAxleWeight = null)
    {
        $this->maximumPermittedAxleWeight = $maximumPermittedAxleWeight;
        return $this;
    }
    /**
     * Get axleWeightExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAxleWeightExtension()
    {
        return $this->axleWeightExtension;
    }
    /**
     * Set axleWeightExtension value
     * @param \StructType\ExtensionType $axleWeightExtension
     * @return \StructType\AxleWeight
     */
    public function setAxleWeightExtension(\StructType\ExtensionType $axleWeightExtension = null)
    {
        $this->axleWeightExtension = $axleWeightExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AxleWeight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
