<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnotatedStopPointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: View of a SCHEDULED STOP POINT description.
 * @subpackage Structs
 */
class AnnotatedStopPointStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of the stop.
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The TimingPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TimingPoint
     * @var bool
     */
    public $TimingPoint;
    /**
     * The Monitored
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether real-time data is available for the stop. Default is 'true'. Detail level is 'normal'.
     * - minOccurs: 0
     * @var bool
     */
    public $Monitored;
    /**
     * The StopName
     * Meta informations extracted from the WSDL
     * - documentation: Name of SCHEDULED STOP POINT. Detail level is 'normal'. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $StopName;
    /**
     * The StopAreaRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of the sSTOP AREA to which SCHEDULED STOP POINT belongs. +SIRI.v2.0
     * - minOccurs: 0
     * @var \StructType\StopAreaRefStructure
     */
    public $StopAreaRef;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $Features;
    /**
     * The Lines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Lines
     */
    public $Lines;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Coordinates to use to show stop as a poitn on map. Detail level is 'normal'.+SIRI.v2.0
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $Location;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - documentation: Web page associated with Stop. Detail level is 'full'+SIRI.v2.0
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for AnnotatedStopPointStructure
     * @uses AnnotatedStopPointStructure::setStopPointRef()
     * @uses AnnotatedStopPointStructure::setTimingPoint()
     * @uses AnnotatedStopPointStructure::setMonitored()
     * @uses AnnotatedStopPointStructure::setStopName()
     * @uses AnnotatedStopPointStructure::setStopAreaRef()
     * @uses AnnotatedStopPointStructure::setFeatures()
     * @uses AnnotatedStopPointStructure::setLines()
     * @uses AnnotatedStopPointStructure::setLocation()
     * @uses AnnotatedStopPointStructure::setUrl()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param bool $timingPoint
     * @param bool $monitored
     * @param \StructType\NaturalLanguageStringStructure[] $stopName
     * @param \StructType\StopAreaRefStructure $stopAreaRef
     * @param \StructType\Features $features
     * @param \StructType\Lines $lines
     * @param \StructType\LocationStructure $location
     * @param string $url
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $timingPoint = null, $monitored = true, array $stopName = array(), \StructType\StopAreaRefStructure $stopAreaRef = null, \StructType\Features $features = null, \StructType\Lines $lines = null, \StructType\LocationStructure $location = null, $url = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setTimingPoint($timingPoint)
            ->setMonitored($monitored)
            ->setStopName($stopName)
            ->setStopAreaRef($stopAreaRef)
            ->setFeatures($features)
            ->setLines($lines)
            ->setLocation($location)
            ->setUrl($url);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get TimingPoint value
     * @return bool|null
     */
    public function getTimingPoint()
    {
        return $this->TimingPoint;
    }
    /**
     * Set TimingPoint value
     * @param bool $timingPoint
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setTimingPoint($timingPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timingPoint) && !is_bool($timingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($timingPoint)), __LINE__);
        }
        $this->TimingPoint = $timingPoint;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setMonitored($monitored = true)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get StopName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getStopName()
    {
        return $this->StopName;
    }
    /**
     * Set StopName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $stopName
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setStopName(array $stopName = array())
    {
        foreach ($stopName as $annotatedStopPointStructureStopNameItem) {
            // validation for constraint: itemType
            if (!$annotatedStopPointStructureStopNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The StopName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedStopPointStructureStopNameItem) ? get_class($annotatedStopPointStructureStopNameItem) : gettype($annotatedStopPointStructureStopNameItem)), __LINE__);
            }
        }
        $this->StopName = $stopName;
        return $this;
    }
    /**
     * Add item to StopName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function addToStopName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The StopName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopName[] = $item;
        return $this;
    }
    /**
     * Get StopAreaRef value
     * @return \StructType\StopAreaRefStructure|null
     */
    public function getStopAreaRef()
    {
        return $this->StopAreaRef;
    }
    /**
     * Set StopAreaRef value
     * @param \StructType\StopAreaRefStructure $stopAreaRef
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setStopAreaRef(\StructType\StopAreaRefStructure $stopAreaRef = null)
    {
        $this->StopAreaRef = $stopAreaRef;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\Features $features
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get Lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \StructType\Lines $lines
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationStructure|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationStructure $location
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setLocation(\StructType\LocationStructure $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\AnnotatedStopPointStructure
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnotatedStopPointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
