<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnimalPresenceObstruction StructType
 * @subpackage Structs
 */
class AnimalPresenceObstruction extends Obstruction
{
    /**
     * The animalPresenceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $animalPresenceType;
    /**
     * The alive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $alive;
    /**
     * The animalPresenceObstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $animalPresenceObstructionExtension;
    /**
     * Constructor method for AnimalPresenceObstruction
     * @uses AnimalPresenceObstruction::setAnimalPresenceType()
     * @uses AnimalPresenceObstruction::setAlive()
     * @uses AnimalPresenceObstruction::setAnimalPresenceObstructionExtension()
     * @param string $animalPresenceType
     * @param bool $alive
     * @param \StructType\ExtensionType $animalPresenceObstructionExtension
     */
    public function __construct($animalPresenceType = null, $alive = null, \StructType\ExtensionType $animalPresenceObstructionExtension = null)
    {
        $this
            ->setAnimalPresenceType($animalPresenceType)
            ->setAlive($alive)
            ->setAnimalPresenceObstructionExtension($animalPresenceObstructionExtension);
    }
    /**
     * Get animalPresenceType value
     * @return string
     */
    public function getAnimalPresenceType()
    {
        return $this->animalPresenceType;
    }
    /**
     * Set animalPresenceType value
     * @uses \EnumType\AnimalPresenceTypeEnum::valueIsValid()
     * @uses \EnumType\AnimalPresenceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $animalPresenceType
     * @return \StructType\AnimalPresenceObstruction
     */
    public function setAnimalPresenceType($animalPresenceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnimalPresenceTypeEnum::valueIsValid($animalPresenceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $animalPresenceType, implode(', ', \EnumType\AnimalPresenceTypeEnum::getValidValues())), __LINE__);
        }
        $this->animalPresenceType = $animalPresenceType;
        return $this;
    }
    /**
     * Get alive value
     * @return bool|null
     */
    public function getAlive()
    {
        return $this->alive;
    }
    /**
     * Set alive value
     * @param bool $alive
     * @return \StructType\AnimalPresenceObstruction
     */
    public function setAlive($alive = null)
    {
        // validation for constraint: boolean
        if (!is_null($alive) && !is_bool($alive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alive)), __LINE__);
        }
        $this->alive = $alive;
        return $this;
    }
    /**
     * Get animalPresenceObstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAnimalPresenceObstructionExtension()
    {
        return $this->animalPresenceObstructionExtension;
    }
    /**
     * Set animalPresenceObstructionExtension value
     * @param \StructType\ExtensionType $animalPresenceObstructionExtension
     * @return \StructType\AnimalPresenceObstruction
     */
    public function setAnimalPresenceObstructionExtension(\StructType\ExtensionType $animalPresenceObstructionExtension = null)
    {
        $this->animalPresenceObstructionExtension = $animalPresenceObstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnimalPresenceObstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
