<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllFacilitiesFeatureStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Description of the features of any of the available facilities.
 * @subpackage Structs
 */
class AllFacilitiesFeatureStructure extends AbstractStructBase
{
    /**
     * The AccessFacility
     * Meta informations extracted from the WSDL
     * - ref: AccessFacility
     * @var string
     */
    public $AccessFacility;
    /**
     * The AccommodationFacility
     * Meta informations extracted from the WSDL
     * - ref: AccommodationFacility
     * @var string
     */
    public $AccommodationFacility;
    /**
     * The AssistanceFacility
     * Meta informations extracted from the WSDL
     * - ref: AssistanceFacility
     * @var string
     */
    public $AssistanceFacility;
    /**
     * The FareClassFacility
     * Meta informations extracted from the WSDL
     * - ref: FareClassFacility
     * @var string
     */
    public $FareClassFacility;
    /**
     * The HireFacility
     * Meta informations extracted from the WSDL
     * - ref: HireFacility
     * @var string
     */
    public $HireFacility;
    /**
     * The LuggageFacility
     * Meta informations extracted from the WSDL
     * - ref: LuggageFacility
     * @var string
     */
    public $LuggageFacility;
    /**
     * The MobilityFacility
     * Meta informations extracted from the WSDL
     * - ref: MobilityFacility
     * @var string
     */
    public $MobilityFacility;
    /**
     * The NuisanceFacility
     * Meta informations extracted from the WSDL
     * - ref: NuisanceFacility
     * @var string
     */
    public $NuisanceFacility;
    /**
     * The ParkingFacility
     * Meta informations extracted from the WSDL
     * - ref: ParkingFacility
     * @var string
     */
    public $ParkingFacility;
    /**
     * The PassengerCommsFacility
     * Meta informations extracted from the WSDL
     * - ref: PassengerCommsFacility
     * @var string
     */
    public $PassengerCommsFacility;
    /**
     * The PassengerInformationFacility
     * Meta informations extracted from the WSDL
     * - ref: PassengerInformationFacility
     * @var string
     */
    public $PassengerInformationFacility;
    /**
     * The RefreshmentFacility
     * Meta informations extracted from the WSDL
     * - ref: RefreshmentFacility
     * @var string
     */
    public $RefreshmentFacility;
    /**
     * The ReservedSpaceFacility
     * Meta informations extracted from the WSDL
     * - ref: ReservedSpaceFacility
     * @var string
     */
    public $ReservedSpaceFacility;
    /**
     * The RetailFacility
     * Meta informations extracted from the WSDL
     * - ref: RetailFacility
     * @var string
     */
    public $RetailFacility;
    /**
     * The SanitaryFacility
     * Meta informations extracted from the WSDL
     * - ref: SanitaryFacility
     * @var string
     */
    public $SanitaryFacility;
    /**
     * The TicketingFacility
     * Meta informations extracted from the WSDL
     * - ref: TicketingFacility
     * @var string
     */
    public $TicketingFacility;
    /**
     * Constructor method for AllFacilitiesFeatureStructure
     * @uses AllFacilitiesFeatureStructure::setAccessFacility()
     * @uses AllFacilitiesFeatureStructure::setAccommodationFacility()
     * @uses AllFacilitiesFeatureStructure::setAssistanceFacility()
     * @uses AllFacilitiesFeatureStructure::setFareClassFacility()
     * @uses AllFacilitiesFeatureStructure::setHireFacility()
     * @uses AllFacilitiesFeatureStructure::setLuggageFacility()
     * @uses AllFacilitiesFeatureStructure::setMobilityFacility()
     * @uses AllFacilitiesFeatureStructure::setNuisanceFacility()
     * @uses AllFacilitiesFeatureStructure::setParkingFacility()
     * @uses AllFacilitiesFeatureStructure::setPassengerCommsFacility()
     * @uses AllFacilitiesFeatureStructure::setPassengerInformationFacility()
     * @uses AllFacilitiesFeatureStructure::setRefreshmentFacility()
     * @uses AllFacilitiesFeatureStructure::setReservedSpaceFacility()
     * @uses AllFacilitiesFeatureStructure::setRetailFacility()
     * @uses AllFacilitiesFeatureStructure::setSanitaryFacility()
     * @uses AllFacilitiesFeatureStructure::setTicketingFacility()
     * @param string $accessFacility
     * @param string $accommodationFacility
     * @param string $assistanceFacility
     * @param string $fareClassFacility
     * @param string $hireFacility
     * @param string $luggageFacility
     * @param string $mobilityFacility
     * @param string $nuisanceFacility
     * @param string $parkingFacility
     * @param string $passengerCommsFacility
     * @param string $passengerInformationFacility
     * @param string $refreshmentFacility
     * @param string $reservedSpaceFacility
     * @param string $retailFacility
     * @param string $sanitaryFacility
     * @param string $ticketingFacility
     */
    public function __construct($accessFacility = null, $accommodationFacility = null, $assistanceFacility = null, $fareClassFacility = null, $hireFacility = null, $luggageFacility = null, $mobilityFacility = null, $nuisanceFacility = null, $parkingFacility = null, $passengerCommsFacility = null, $passengerInformationFacility = null, $refreshmentFacility = null, $reservedSpaceFacility = null, $retailFacility = null, $sanitaryFacility = null, $ticketingFacility = null)
    {
        $this
            ->setAccessFacility($accessFacility)
            ->setAccommodationFacility($accommodationFacility)
            ->setAssistanceFacility($assistanceFacility)
            ->setFareClassFacility($fareClassFacility)
            ->setHireFacility($hireFacility)
            ->setLuggageFacility($luggageFacility)
            ->setMobilityFacility($mobilityFacility)
            ->setNuisanceFacility($nuisanceFacility)
            ->setParkingFacility($parkingFacility)
            ->setPassengerCommsFacility($passengerCommsFacility)
            ->setPassengerInformationFacility($passengerInformationFacility)
            ->setRefreshmentFacility($refreshmentFacility)
            ->setReservedSpaceFacility($reservedSpaceFacility)
            ->setRetailFacility($retailFacility)
            ->setSanitaryFacility($sanitaryFacility)
            ->setTicketingFacility($ticketingFacility);
    }
    /**
     * Get AccessFacility value
     * @return string|null
     */
    public function getAccessFacility()
    {
        return $this->AccessFacility;
    }
    /**
     * Set AccessFacility value
     * @uses \EnumType\AccessFacilityEnumeration::valueIsValid()
     * @uses \EnumType\AccessFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setAccessFacility($accessFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessFacilityEnumeration::valueIsValid($accessFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessFacility, implode(', ', \EnumType\AccessFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessFacility = $accessFacility;
        return $this;
    }
    /**
     * Get AccommodationFacility value
     * @return string|null
     */
    public function getAccommodationFacility()
    {
        return $this->AccommodationFacility;
    }
    /**
     * Set AccommodationFacility value
     * @uses \EnumType\AccommodationFacilityEnumeration::valueIsValid()
     * @uses \EnumType\AccommodationFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accommodationFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setAccommodationFacility($accommodationFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccommodationFacilityEnumeration::valueIsValid($accommodationFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accommodationFacility, implode(', ', \EnumType\AccommodationFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->AccommodationFacility = $accommodationFacility;
        return $this;
    }
    /**
     * Get AssistanceFacility value
     * @return string|null
     */
    public function getAssistanceFacility()
    {
        return $this->AssistanceFacility;
    }
    /**
     * Set AssistanceFacility value
     * @uses \EnumType\AssistanceFacilityEnumeration::valueIsValid()
     * @uses \EnumType\AssistanceFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assistanceFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setAssistanceFacility($assistanceFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AssistanceFacilityEnumeration::valueIsValid($assistanceFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $assistanceFacility, implode(', ', \EnumType\AssistanceFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->AssistanceFacility = $assistanceFacility;
        return $this;
    }
    /**
     * Get FareClassFacility value
     * @return string|null
     */
    public function getFareClassFacility()
    {
        return $this->FareClassFacility;
    }
    /**
     * Set FareClassFacility value
     * @uses \EnumType\FareClassFacilityEnumeration::valueIsValid()
     * @uses \EnumType\FareClassFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareClassFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setFareClassFacility($fareClassFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FareClassFacilityEnumeration::valueIsValid($fareClassFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fareClassFacility, implode(', ', \EnumType\FareClassFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->FareClassFacility = $fareClassFacility;
        return $this;
    }
    /**
     * Get HireFacility value
     * @return string|null
     */
    public function getHireFacility()
    {
        return $this->HireFacility;
    }
    /**
     * Set HireFacility value
     * @uses \EnumType\HireFacilityEnumeration::valueIsValid()
     * @uses \EnumType\HireFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hireFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setHireFacility($hireFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HireFacilityEnumeration::valueIsValid($hireFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hireFacility, implode(', ', \EnumType\HireFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->HireFacility = $hireFacility;
        return $this;
    }
    /**
     * Get LuggageFacility value
     * @return string|null
     */
    public function getLuggageFacility()
    {
        return $this->LuggageFacility;
    }
    /**
     * Set LuggageFacility value
     * @uses \EnumType\LuggageFacilityEnumeration::valueIsValid()
     * @uses \EnumType\LuggageFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $luggageFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setLuggageFacility($luggageFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LuggageFacilityEnumeration::valueIsValid($luggageFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $luggageFacility, implode(', ', \EnumType\LuggageFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->LuggageFacility = $luggageFacility;
        return $this;
    }
    /**
     * Get MobilityFacility value
     * @return string|null
     */
    public function getMobilityFacility()
    {
        return $this->MobilityFacility;
    }
    /**
     * Set MobilityFacility value
     * @uses \EnumType\MobilityFacilityEnumeration::valueIsValid()
     * @uses \EnumType\MobilityFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobilityFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setMobilityFacility($mobilityFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MobilityFacilityEnumeration::valueIsValid($mobilityFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobilityFacility, implode(', ', \EnumType\MobilityFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->MobilityFacility = $mobilityFacility;
        return $this;
    }
    /**
     * Get NuisanceFacility value
     * @return string|null
     */
    public function getNuisanceFacility()
    {
        return $this->NuisanceFacility;
    }
    /**
     * Set NuisanceFacility value
     * @uses \EnumType\NuisanceFacilityEnumeration::valueIsValid()
     * @uses \EnumType\NuisanceFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nuisanceFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setNuisanceFacility($nuisanceFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NuisanceFacilityEnumeration::valueIsValid($nuisanceFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nuisanceFacility, implode(', ', \EnumType\NuisanceFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->NuisanceFacility = $nuisanceFacility;
        return $this;
    }
    /**
     * Get ParkingFacility value
     * @return string|null
     */
    public function getParkingFacility()
    {
        return $this->ParkingFacility;
    }
    /**
     * Set ParkingFacility value
     * @uses \EnumType\ParkingFacilityEnumeration::valueIsValid()
     * @uses \EnumType\ParkingFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkingFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setParkingFacility($parkingFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParkingFacilityEnumeration::valueIsValid($parkingFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parkingFacility, implode(', ', \EnumType\ParkingFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->ParkingFacility = $parkingFacility;
        return $this;
    }
    /**
     * Get PassengerCommsFacility value
     * @return string|null
     */
    public function getPassengerCommsFacility()
    {
        return $this->PassengerCommsFacility;
    }
    /**
     * Set PassengerCommsFacility value
     * @uses \EnumType\PassengerCommsFacilityEnumeration::valueIsValid()
     * @uses \EnumType\PassengerCommsFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $passengerCommsFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setPassengerCommsFacility($passengerCommsFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerCommsFacilityEnumeration::valueIsValid($passengerCommsFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $passengerCommsFacility, implode(', ', \EnumType\PassengerCommsFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->PassengerCommsFacility = $passengerCommsFacility;
        return $this;
    }
    /**
     * Get PassengerInformationFacility value
     * @return string|null
     */
    public function getPassengerInformationFacility()
    {
        return $this->PassengerInformationFacility;
    }
    /**
     * Set PassengerInformationFacility value
     * @uses \EnumType\PassengerInformationFacilityEnumeration::valueIsValid()
     * @uses \EnumType\PassengerInformationFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $passengerInformationFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setPassengerInformationFacility($passengerInformationFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerInformationFacilityEnumeration::valueIsValid($passengerInformationFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $passengerInformationFacility, implode(', ', \EnumType\PassengerInformationFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->PassengerInformationFacility = $passengerInformationFacility;
        return $this;
    }
    /**
     * Get RefreshmentFacility value
     * @return string|null
     */
    public function getRefreshmentFacility()
    {
        return $this->RefreshmentFacility;
    }
    /**
     * Set RefreshmentFacility value
     * @uses \EnumType\RefreshmentFacilityEnumeration::valueIsValid()
     * @uses \EnumType\RefreshmentFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refreshmentFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setRefreshmentFacility($refreshmentFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RefreshmentFacilityEnumeration::valueIsValid($refreshmentFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $refreshmentFacility, implode(', ', \EnumType\RefreshmentFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->RefreshmentFacility = $refreshmentFacility;
        return $this;
    }
    /**
     * Get ReservedSpaceFacility value
     * @return string|null
     */
    public function getReservedSpaceFacility()
    {
        return $this->ReservedSpaceFacility;
    }
    /**
     * Set ReservedSpaceFacility value
     * @uses \EnumType\ReservedSpaceFacilityEnumeration::valueIsValid()
     * @uses \EnumType\ReservedSpaceFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservedSpaceFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setReservedSpaceFacility($reservedSpaceFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReservedSpaceFacilityEnumeration::valueIsValid($reservedSpaceFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reservedSpaceFacility, implode(', ', \EnumType\ReservedSpaceFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->ReservedSpaceFacility = $reservedSpaceFacility;
        return $this;
    }
    /**
     * Get RetailFacility value
     * @return string|null
     */
    public function getRetailFacility()
    {
        return $this->RetailFacility;
    }
    /**
     * Set RetailFacility value
     * @uses \EnumType\RetailFacilityEnumeration::valueIsValid()
     * @uses \EnumType\RetailFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retailFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setRetailFacility($retailFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetailFacilityEnumeration::valueIsValid($retailFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retailFacility, implode(', ', \EnumType\RetailFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->RetailFacility = $retailFacility;
        return $this;
    }
    /**
     * Get SanitaryFacility value
     * @return string|null
     */
    public function getSanitaryFacility()
    {
        return $this->SanitaryFacility;
    }
    /**
     * Set SanitaryFacility value
     * @uses \EnumType\SanitaryFacilityEnumeration::valueIsValid()
     * @uses \EnumType\SanitaryFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sanitaryFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setSanitaryFacility($sanitaryFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SanitaryFacilityEnumeration::valueIsValid($sanitaryFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sanitaryFacility, implode(', ', \EnumType\SanitaryFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->SanitaryFacility = $sanitaryFacility;
        return $this;
    }
    /**
     * Get TicketingFacility value
     * @return string|null
     */
    public function getTicketingFacility()
    {
        return $this->TicketingFacility;
    }
    /**
     * Set TicketingFacility value
     * @uses \EnumType\TicketingFacilityEnumeration::valueIsValid()
     * @uses \EnumType\TicketingFacilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketingFacility
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public function setTicketingFacility($ticketingFacility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketingFacilityEnumeration::valueIsValid($ticketingFacility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ticketingFacility, implode(', ', \EnumType\TicketingFacilityEnumeration::getValidValues())), __LINE__);
        }
        $this->TicketingFacility = $ticketingFacility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllFacilitiesFeatureStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
