<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlertCPoint StructType
 * @subpackage Structs
 */
abstract class AlertCPoint extends AbstractStructBase
{
    /**
     * The alertCLocationCountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $alertCLocationCountryCode;
    /**
     * The alertCLocationTableNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $alertCLocationTableNumber;
    /**
     * The alertCLocationTableVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $alertCLocationTableVersion;
    /**
     * The alertCPointExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $alertCPointExtension;
    /**
     * Constructor method for AlertCPoint
     * @uses AlertCPoint::setAlertCLocationCountryCode()
     * @uses AlertCPoint::setAlertCLocationTableNumber()
     * @uses AlertCPoint::setAlertCLocationTableVersion()
     * @uses AlertCPoint::setAlertCPointExtension()
     * @param string $alertCLocationCountryCode
     * @param string $alertCLocationTableNumber
     * @param string $alertCLocationTableVersion
     * @param \StructType\ExtensionType $alertCPointExtension
     */
    public function __construct($alertCLocationCountryCode = null, $alertCLocationTableNumber = null, $alertCLocationTableVersion = null, \StructType\ExtensionType $alertCPointExtension = null)
    {
        $this
            ->setAlertCLocationCountryCode($alertCLocationCountryCode)
            ->setAlertCLocationTableNumber($alertCLocationTableNumber)
            ->setAlertCLocationTableVersion($alertCLocationTableVersion)
            ->setAlertCPointExtension($alertCPointExtension);
    }
    /**
     * Get alertCLocationCountryCode value
     * @return string
     */
    public function getAlertCLocationCountryCode()
    {
        return $this->alertCLocationCountryCode;
    }
    /**
     * Set alertCLocationCountryCode value
     * @param string $alertCLocationCountryCode
     * @return \StructType\AlertCPoint
     */
    public function setAlertCLocationCountryCode($alertCLocationCountryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertCLocationCountryCode) && strlen($alertCLocationCountryCode) > 1024) || (is_array($alertCLocationCountryCode) && count($alertCLocationCountryCode) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($alertCLocationCountryCode) ? strlen($alertCLocationCountryCode) : count($alertCLocationCountryCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertCLocationCountryCode) && !is_string($alertCLocationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertCLocationCountryCode)), __LINE__);
        }
        $this->alertCLocationCountryCode = $alertCLocationCountryCode;
        return $this;
    }
    /**
     * Get alertCLocationTableNumber value
     * @return string
     */
    public function getAlertCLocationTableNumber()
    {
        return $this->alertCLocationTableNumber;
    }
    /**
     * Set alertCLocationTableNumber value
     * @param string $alertCLocationTableNumber
     * @return \StructType\AlertCPoint
     */
    public function setAlertCLocationTableNumber($alertCLocationTableNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertCLocationTableNumber) && strlen($alertCLocationTableNumber) > 1024) || (is_array($alertCLocationTableNumber) && count($alertCLocationTableNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($alertCLocationTableNumber) ? strlen($alertCLocationTableNumber) : count($alertCLocationTableNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertCLocationTableNumber) && !is_string($alertCLocationTableNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertCLocationTableNumber)), __LINE__);
        }
        $this->alertCLocationTableNumber = $alertCLocationTableNumber;
        return $this;
    }
    /**
     * Get alertCLocationTableVersion value
     * @return string
     */
    public function getAlertCLocationTableVersion()
    {
        return $this->alertCLocationTableVersion;
    }
    /**
     * Set alertCLocationTableVersion value
     * @param string $alertCLocationTableVersion
     * @return \StructType\AlertCPoint
     */
    public function setAlertCLocationTableVersion($alertCLocationTableVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertCLocationTableVersion) && strlen($alertCLocationTableVersion) > 1024) || (is_array($alertCLocationTableVersion) && count($alertCLocationTableVersion) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($alertCLocationTableVersion) ? strlen($alertCLocationTableVersion) : count($alertCLocationTableVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertCLocationTableVersion) && !is_string($alertCLocationTableVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertCLocationTableVersion)), __LINE__);
        }
        $this->alertCLocationTableVersion = $alertCLocationTableVersion;
        return $this;
    }
    /**
     * Get alertCPointExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAlertCPointExtension()
    {
        return $this->alertCPointExtension;
    }
    /**
     * Set alertCPointExtension value
     * @param \StructType\ExtensionType $alertCPointExtension
     * @return \StructType\AlertCPoint
     */
    public function setAlertCPointExtension(\StructType\ExtensionType $alertCPointExtension = null)
    {
        $this->alertCPointExtension = $alertCPointExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlertCPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
