<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlertCLocation StructType
 * @subpackage Structs
 */
class AlertCLocation extends AbstractStructBase
{
    /**
     * The specificLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $specificLocation;
    /**
     * The alertCLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $alertCLocationName;
    /**
     * The alertCLocationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $alertCLocationExtension;
    /**
     * Constructor method for AlertCLocation
     * @uses AlertCLocation::setSpecificLocation()
     * @uses AlertCLocation::setAlertCLocationName()
     * @uses AlertCLocation::setAlertCLocationExtension()
     * @param int $specificLocation
     * @param \StructType\MultilingualString $alertCLocationName
     * @param \StructType\ExtensionType $alertCLocationExtension
     */
    public function __construct($specificLocation = null, \StructType\MultilingualString $alertCLocationName = null, \StructType\ExtensionType $alertCLocationExtension = null)
    {
        $this
            ->setSpecificLocation($specificLocation)
            ->setAlertCLocationName($alertCLocationName)
            ->setAlertCLocationExtension($alertCLocationExtension);
    }
    /**
     * Get specificLocation value
     * @return int
     */
    public function getSpecificLocation()
    {
        return $this->specificLocation;
    }
    /**
     * Set specificLocation value
     * @param int $specificLocation
     * @return \StructType\AlertCLocation
     */
    public function setSpecificLocation($specificLocation = null)
    {
        // validation for constraint: int
        if (!is_null($specificLocation) && !is_numeric($specificLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($specificLocation)), __LINE__);
        }
        $this->specificLocation = $specificLocation;
        return $this;
    }
    /**
     * Get alertCLocationName value
     * @return \StructType\MultilingualString|null
     */
    public function getAlertCLocationName()
    {
        return $this->alertCLocationName;
    }
    /**
     * Set alertCLocationName value
     * @param \StructType\MultilingualString $alertCLocationName
     * @return \StructType\AlertCLocation
     */
    public function setAlertCLocationName(\StructType\MultilingualString $alertCLocationName = null)
    {
        $this->alertCLocationName = $alertCLocationName;
        return $this;
    }
    /**
     * Get alertCLocationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getAlertCLocationExtension()
    {
        return $this->alertCLocationExtension;
    }
    /**
     * Set alertCLocationExtension value
     * @param \StructType\ExtensionType $alertCLocationExtension
     * @return \StructType\AlertCLocation
     */
    public function setAlertCLocationExtension(\StructType\ExtensionType $alertCLocationExtension = null)
    {
        $this->alertCLocationExtension = $alertCLocationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlertCLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
