<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedVehicleJourneyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about a VEHICLE JOURNEY affected by a SITUATION. | Use of simple reference is deprecated
 * @subpackage Structs
 */
class AffectedVehicleJourneyStructure extends AbstractStructBase
{
    /**
     * The FramedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Refercence to a VEHICLE JOURENY framed by the day. SIRI 2.0
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The VehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a service VEHICLE JOURNEY affected by a SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\VehicleJourneyRefStructure[]
     */
    public $VehicleJourneyRef;
    /**
     * The DatedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a specific DATED VEHICLE JOURNEY affected by a SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedVehicleJourneyRefStructure[]
     */
    public $DatedVehicleJourneyRef;
    /**
     * The JourneyName
     * Meta informations extracted from the WSDL
     * - documentation: Name of journey affected by a SITUATION. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $JourneyName;
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - documentation: OPERATOR of LINE affected by SITUATION.
     * - minOccurs: 0
     * @var \StructType\AffectedOperatorStructure
     */
    public $Operator;
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to the LINE of the journey affected by an SITUATION.
     * - minOccurs: 0
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The PublishedLineName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: DIRECTION of LINE in which journey runs.
     * - minOccurs: 0
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The BlockRef
     * Meta informations extracted from the WSDL
     * - documentation: BLOCK which journey runs. +SIRI 2.0
     * - minOccurs: 0
     * @var \StructType\BlockRefStructure
     */
    public $BlockRef;
    /**
     * The TrainNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TrainNumbers
     */
    public $TrainNumbers;
    /**
     * The JourneyParts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JourneyParts
     */
    public $JourneyParts;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - documentation: Origin SCHEDULED STOP POINTs from which the LINE runs. [equivalent to pti15 1 start_point route_description_type]
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedStopPointStructure[]
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - documentation: Destination SCHEDULED STOP POINTs to which the LINE runs. [equivalent to pti15 2 destination route_description_type]
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedStopPointStructure[]
     */
    public $Destinations;
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - documentation: ROUTE affected by the SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedRouteStructure[]
     */
    public $Route;
    /**
     * The OriginAimedDepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: Timetabled departure tme of journey from Origin.
     * - minOccurs: 0
     * @var string
     */
    public $OriginAimedDepartureTime;
    /**
     * The DestinationAimedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Timetabled arrival time of journey at Destination.
     * - minOccurs: 0
     * @var string
     */
    public $DestinationAimedArrivalTime;
    /**
     * The OriginDisplayAtDestination
     * Meta informations extracted from the WSDL
     * - documentation: DESTINATION name shown for journey at the origin. Can be Used to identify joruney for user. (+SIRI 2.0),
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguagePlaceNameStructure[]
     */
    public $OriginDisplayAtDestination;
    /**
     * The DestinationDisplayAtOrigin
     * Meta informations extracted from the WSDL
     * - documentation: DESTINATION name shown for journey at the origin. Can be Used to identify joruney for user. (+SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguagePlaceNameStructure[]
     */
    public $DestinationDisplayAtOrigin;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Accessibility Disruption status ofto JOURNEY, as affected by Situation.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The JourneyCondition
     * Meta informations extracted from the WSDL
     * - documentation: enum Status of service for this Vehicle Journey - TPEG value. Multiple Condtions can be valid at the same time. (+SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $JourneyCondition;
    /**
     * The Calls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Calls
     */
    public $Calls;
    /**
     * The Facilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Facilities
     */
    public $Facilities;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedVehicleJourneyStructure
     * @uses AffectedVehicleJourneyStructure::setFramedVehicleJourneyRef()
     * @uses AffectedVehicleJourneyStructure::setVehicleJourneyRef()
     * @uses AffectedVehicleJourneyStructure::setDatedVehicleJourneyRef()
     * @uses AffectedVehicleJourneyStructure::setJourneyName()
     * @uses AffectedVehicleJourneyStructure::setOperator()
     * @uses AffectedVehicleJourneyStructure::setLineRef()
     * @uses AffectedVehicleJourneyStructure::setPublishedLineName()
     * @uses AffectedVehicleJourneyStructure::setDirectionRef()
     * @uses AffectedVehicleJourneyStructure::setBlockRef()
     * @uses AffectedVehicleJourneyStructure::setTrainNumbers()
     * @uses AffectedVehicleJourneyStructure::setJourneyParts()
     * @uses AffectedVehicleJourneyStructure::setOrigins()
     * @uses AffectedVehicleJourneyStructure::setDestinations()
     * @uses AffectedVehicleJourneyStructure::setRoute()
     * @uses AffectedVehicleJourneyStructure::setOriginAimedDepartureTime()
     * @uses AffectedVehicleJourneyStructure::setDestinationAimedArrivalTime()
     * @uses AffectedVehicleJourneyStructure::setOriginDisplayAtDestination()
     * @uses AffectedVehicleJourneyStructure::setDestinationDisplayAtOrigin()
     * @uses AffectedVehicleJourneyStructure::setAccessibilityAssessment()
     * @uses AffectedVehicleJourneyStructure::setJourneyCondition()
     * @uses AffectedVehicleJourneyStructure::setCalls()
     * @uses AffectedVehicleJourneyStructure::setFacilities()
     * @uses AffectedVehicleJourneyStructure::setExtensions()
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\VehicleJourneyRefStructure[] $vehicleJourneyRef
     * @param \StructType\DatedVehicleJourneyRefStructure[] $datedVehicleJourneyRef
     * @param \StructType\NaturalLanguageStringStructure[] $journeyName
     * @param \StructType\AffectedOperatorStructure $operator
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\BlockRefStructure $blockRef
     * @param \StructType\TrainNumbers $trainNumbers
     * @param \StructType\JourneyParts $journeyParts
     * @param \StructType\AffectedStopPointStructure[] $origins
     * @param \StructType\AffectedStopPointStructure[] $destinations
     * @param \StructType\AffectedRouteStructure[] $route
     * @param string $originAimedDepartureTime
     * @param string $destinationAimedArrivalTime
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $originDisplayAtDestination
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $destinationDisplayAtOrigin
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param string[] $journeyCondition
     * @param \StructType\Calls $calls
     * @param \StructType\Facilities $facilities
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, array $vehicleJourneyRef = array(), array $datedVehicleJourneyRef = array(), array $journeyName = array(), \StructType\AffectedOperatorStructure $operator = null, \StructType\LineRefStructure $lineRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\BlockRefStructure $blockRef = null, \StructType\TrainNumbers $trainNumbers = null, \StructType\JourneyParts $journeyParts = null, array $origins = array(), array $destinations = array(), array $route = array(), $originAimedDepartureTime = null, $destinationAimedArrivalTime = null, array $originDisplayAtDestination = array(), array $destinationDisplayAtOrigin = array(), \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, array $journeyCondition = array(), \StructType\Calls $calls = null, \StructType\Facilities $facilities = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setDatedVehicleJourneyRef($datedVehicleJourneyRef)
            ->setJourneyName($journeyName)
            ->setOperator($operator)
            ->setLineRef($lineRef)
            ->setPublishedLineName($publishedLineName)
            ->setDirectionRef($directionRef)
            ->setBlockRef($blockRef)
            ->setTrainNumbers($trainNumbers)
            ->setJourneyParts($journeyParts)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setRoute($route)
            ->setOriginAimedDepartureTime($originAimedDepartureTime)
            ->setDestinationAimedArrivalTime($destinationAimedArrivalTime)
            ->setOriginDisplayAtDestination($originDisplayAtDestination)
            ->setDestinationDisplayAtOrigin($destinationDisplayAtOrigin)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setJourneyCondition($journeyCondition)
            ->setCalls($calls)
            ->setFacilities($facilities)
            ->setExtensions($extensions);
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\VehicleJourneyRefStructure[]|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleJourneyRefStructure[] $vehicleJourneyRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setVehicleJourneyRef(array $vehicleJourneyRef = array())
    {
        foreach ($vehicleJourneyRef as $affectedVehicleJourneyStructureVehicleJourneyRefItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureVehicleJourneyRefItem instanceof \StructType\VehicleJourneyRefStructure) {
                throw new \InvalidArgumentException(sprintf('The VehicleJourneyRef property can only contain items of \StructType\VehicleJourneyRefStructure, "%s" given', is_object($affectedVehicleJourneyStructureVehicleJourneyRefItem) ? get_class($affectedVehicleJourneyStructureVehicleJourneyRefItem) : gettype($affectedVehicleJourneyStructureVehicleJourneyRefItem)), __LINE__);
            }
        }
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Add item to VehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleJourneyRefStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToVehicleJourneyRef(\StructType\VehicleJourneyRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleJourneyRefStructure) {
            throw new \InvalidArgumentException(sprintf('The VehicleJourneyRef property can only contain items of \StructType\VehicleJourneyRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleJourneyRef[] = $item;
        return $this;
    }
    /**
     * Get DatedVehicleJourneyRef value
     * @return \StructType\DatedVehicleJourneyRefStructure[]|null
     */
    public function getDatedVehicleJourneyRef()
    {
        return $this->DatedVehicleJourneyRef;
    }
    /**
     * Set DatedVehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedVehicleJourneyRefStructure[] $datedVehicleJourneyRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setDatedVehicleJourneyRef(array $datedVehicleJourneyRef = array())
    {
        foreach ($datedVehicleJourneyRef as $affectedVehicleJourneyStructureDatedVehicleJourneyRefItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureDatedVehicleJourneyRefItem instanceof \StructType\DatedVehicleJourneyRefStructure) {
                throw new \InvalidArgumentException(sprintf('The DatedVehicleJourneyRef property can only contain items of \StructType\DatedVehicleJourneyRefStructure, "%s" given', is_object($affectedVehicleJourneyStructureDatedVehicleJourneyRefItem) ? get_class($affectedVehicleJourneyStructureDatedVehicleJourneyRefItem) : gettype($affectedVehicleJourneyStructureDatedVehicleJourneyRefItem)), __LINE__);
            }
        }
        $this->DatedVehicleJourneyRef = $datedVehicleJourneyRef;
        return $this;
    }
    /**
     * Add item to DatedVehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedVehicleJourneyRefStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToDatedVehicleJourneyRef(\StructType\DatedVehicleJourneyRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedVehicleJourneyRefStructure) {
            throw new \InvalidArgumentException(sprintf('The DatedVehicleJourneyRef property can only contain items of \StructType\DatedVehicleJourneyRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DatedVehicleJourneyRef[] = $item;
        return $this;
    }
    /**
     * Get JourneyName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getJourneyName()
    {
        return $this->JourneyName;
    }
    /**
     * Set JourneyName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $journeyName
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setJourneyName(array $journeyName = array())
    {
        foreach ($journeyName as $affectedVehicleJourneyStructureJourneyNameItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureJourneyNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The JourneyName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedVehicleJourneyStructureJourneyNameItem) ? get_class($affectedVehicleJourneyStructureJourneyNameItem) : gettype($affectedVehicleJourneyStructureJourneyNameItem)), __LINE__);
            }
        }
        $this->JourneyName = $journeyName;
        return $this;
    }
    /**
     * Add item to JourneyName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToJourneyName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The JourneyName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JourneyName[] = $item;
        return $this;
    }
    /**
     * Get Operator value
     * @return \StructType\AffectedOperatorStructure|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @param \StructType\AffectedOperatorStructure $operator
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setOperator(\StructType\AffectedOperatorStructure $operator = null)
    {
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get BlockRef value
     * @return \StructType\BlockRefStructure|null
     */
    public function getBlockRef()
    {
        return $this->BlockRef;
    }
    /**
     * Set BlockRef value
     * @param \StructType\BlockRefStructure $blockRef
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setBlockRef(\StructType\BlockRefStructure $blockRef = null)
    {
        $this->BlockRef = $blockRef;
        return $this;
    }
    /**
     * Get TrainNumbers value
     * @return \StructType\TrainNumbers|null
     */
    public function getTrainNumbers()
    {
        return $this->TrainNumbers;
    }
    /**
     * Set TrainNumbers value
     * @param \StructType\TrainNumbers $trainNumbers
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setTrainNumbers(\StructType\TrainNumbers $trainNumbers = null)
    {
        $this->TrainNumbers = $trainNumbers;
        return $this;
    }
    /**
     * Get JourneyParts value
     * @return \StructType\JourneyParts|null
     */
    public function getJourneyParts()
    {
        return $this->JourneyParts;
    }
    /**
     * Set JourneyParts value
     * @param \StructType\JourneyParts $journeyParts
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setJourneyParts(\StructType\JourneyParts $journeyParts = null)
    {
        $this->JourneyParts = $journeyParts;
        return $this;
    }
    /**
     * Get Origins value
     * @return \StructType\AffectedStopPointStructure[]|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure[] $origins
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setOrigins(array $origins = array())
    {
        foreach ($origins as $affectedVehicleJourneyStructureOriginsItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureOriginsItem instanceof \StructType\AffectedStopPointStructure) {
                throw new \InvalidArgumentException(sprintf('The Origins property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($affectedVehicleJourneyStructureOriginsItem) ? get_class($affectedVehicleJourneyStructureOriginsItem) : gettype($affectedVehicleJourneyStructureOriginsItem)), __LINE__);
            }
        }
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Add item to Origins value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToOrigins(\StructType\AffectedStopPointStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedStopPointStructure) {
            throw new \InvalidArgumentException(sprintf('The Origins property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Origins[] = $item;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \StructType\AffectedStopPointStructure[]|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure[] $destinations
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setDestinations(array $destinations = array())
    {
        foreach ($destinations as $affectedVehicleJourneyStructureDestinationsItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureDestinationsItem instanceof \StructType\AffectedStopPointStructure) {
                throw new \InvalidArgumentException(sprintf('The Destinations property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($affectedVehicleJourneyStructureDestinationsItem) ? get_class($affectedVehicleJourneyStructureDestinationsItem) : gettype($affectedVehicleJourneyStructureDestinationsItem)), __LINE__);
            }
        }
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Add item to Destinations value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToDestinations(\StructType\AffectedStopPointStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedStopPointStructure) {
            throw new \InvalidArgumentException(sprintf('The Destinations property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Destinations[] = $item;
        return $this;
    }
    /**
     * Get Route value
     * @return \StructType\AffectedRouteStructure[]|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRouteStructure[] $route
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setRoute(array $route = array())
    {
        foreach ($route as $affectedVehicleJourneyStructureRouteItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureRouteItem instanceof \StructType\AffectedRouteStructure) {
                throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\AffectedRouteStructure, "%s" given', is_object($affectedVehicleJourneyStructureRouteItem) ? get_class($affectedVehicleJourneyStructureRouteItem) : gettype($affectedVehicleJourneyStructureRouteItem)), __LINE__);
            }
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRouteStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToRoute(\StructType\AffectedRouteStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedRouteStructure) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\AffectedRouteStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Get OriginAimedDepartureTime value
     * @return string|null
     */
    public function getOriginAimedDepartureTime()
    {
        return $this->OriginAimedDepartureTime;
    }
    /**
     * Set OriginAimedDepartureTime value
     * @param string $originAimedDepartureTime
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setOriginAimedDepartureTime($originAimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($originAimedDepartureTime) && !is_string($originAimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originAimedDepartureTime)), __LINE__);
        }
        $this->OriginAimedDepartureTime = $originAimedDepartureTime;
        return $this;
    }
    /**
     * Get DestinationAimedArrivalTime value
     * @return string|null
     */
    public function getDestinationAimedArrivalTime()
    {
        return $this->DestinationAimedArrivalTime;
    }
    /**
     * Set DestinationAimedArrivalTime value
     * @param string $destinationAimedArrivalTime
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setDestinationAimedArrivalTime($destinationAimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAimedArrivalTime) && !is_string($destinationAimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAimedArrivalTime)), __LINE__);
        }
        $this->DestinationAimedArrivalTime = $destinationAimedArrivalTime;
        return $this;
    }
    /**
     * Get OriginDisplayAtDestination value
     * @return \StructType\NaturalLanguagePlaceNameStructure[]|null
     */
    public function getOriginDisplayAtDestination()
    {
        return $this->OriginDisplayAtDestination;
    }
    /**
     * Set OriginDisplayAtDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $originDisplayAtDestination
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setOriginDisplayAtDestination(array $originDisplayAtDestination = array())
    {
        foreach ($originDisplayAtDestination as $affectedVehicleJourneyStructureOriginDisplayAtDestinationItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureOriginDisplayAtDestinationItem instanceof \StructType\NaturalLanguagePlaceNameStructure) {
                throw new \InvalidArgumentException(sprintf('The OriginDisplayAtDestination property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($affectedVehicleJourneyStructureOriginDisplayAtDestinationItem) ? get_class($affectedVehicleJourneyStructureOriginDisplayAtDestinationItem) : gettype($affectedVehicleJourneyStructureOriginDisplayAtDestinationItem)), __LINE__);
            }
        }
        $this->OriginDisplayAtDestination = $originDisplayAtDestination;
        return $this;
    }
    /**
     * Add item to OriginDisplayAtDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToOriginDisplayAtDestination(\StructType\NaturalLanguagePlaceNameStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguagePlaceNameStructure) {
            throw new \InvalidArgumentException(sprintf('The OriginDisplayAtDestination property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDisplayAtDestination[] = $item;
        return $this;
    }
    /**
     * Get DestinationDisplayAtOrigin value
     * @return \StructType\NaturalLanguagePlaceNameStructure[]|null
     */
    public function getDestinationDisplayAtOrigin()
    {
        return $this->DestinationDisplayAtOrigin;
    }
    /**
     * Set DestinationDisplayAtOrigin value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $destinationDisplayAtOrigin
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setDestinationDisplayAtOrigin(array $destinationDisplayAtOrigin = array())
    {
        foreach ($destinationDisplayAtOrigin as $affectedVehicleJourneyStructureDestinationDisplayAtOriginItem) {
            // validation for constraint: itemType
            if (!$affectedVehicleJourneyStructureDestinationDisplayAtOriginItem instanceof \StructType\NaturalLanguagePlaceNameStructure) {
                throw new \InvalidArgumentException(sprintf('The DestinationDisplayAtOrigin property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($affectedVehicleJourneyStructureDestinationDisplayAtOriginItem) ? get_class($affectedVehicleJourneyStructureDestinationDisplayAtOriginItem) : gettype($affectedVehicleJourneyStructureDestinationDisplayAtOriginItem)), __LINE__);
            }
        }
        $this->DestinationDisplayAtOrigin = $destinationDisplayAtOrigin;
        return $this;
    }
    /**
     * Add item to DestinationDisplayAtOrigin value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToDestinationDisplayAtOrigin(\StructType\NaturalLanguagePlaceNameStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguagePlaceNameStructure) {
            throw new \InvalidArgumentException(sprintf('The DestinationDisplayAtOrigin property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DestinationDisplayAtOrigin[] = $item;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get JourneyCondition value
     * @return string[]|null
     */
    public function getJourneyCondition()
    {
        return $this->JourneyCondition;
    }
    /**
     * Set JourneyCondition value
     * @uses \EnumType\ServiceConditionEnumeration::valueIsValid()
     * @uses \EnumType\ServiceConditionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $journeyCondition
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setJourneyCondition(array $journeyCondition = array())
    {
        $invalidValues = array();
        foreach ($journeyCondition as $affectedVehicleJourneyStructureJourneyConditionItem) {
            if (!\EnumType\ServiceConditionEnumeration::valueIsValid($affectedVehicleJourneyStructureJourneyConditionItem)) {
                $invalidValues[] = var_export($affectedVehicleJourneyStructureJourneyConditionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ServiceConditionEnumeration::getValidValues())), __LINE__);
        }
        $this->JourneyCondition = $journeyCondition;
        return $this;
    }
    /**
     * Add item to JourneyCondition value
     * @uses \EnumType\ServiceConditionEnumeration::valueIsValid()
     * @uses \EnumType\ServiceConditionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function addToJourneyCondition($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceConditionEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ServiceConditionEnumeration::getValidValues())), __LINE__);
        }
        $this->JourneyCondition[] = $item;
        return $this;
    }
    /**
     * Get Calls value
     * @return \StructType\Calls|null
     */
    public function getCalls()
    {
        return $this->Calls;
    }
    /**
     * Set Calls value
     * @param \StructType\Calls $calls
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setCalls(\StructType\Calls $calls = null)
    {
        $this->Calls = $calls;
        return $this;
    }
    /**
     * Get Facilities value
     * @return \StructType\Facilities|null
     */
    public function getFacilities()
    {
        return $this->Facilities;
    }
    /**
     * Set Facilities value
     * @param \StructType\Facilities $facilities
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setFacilities(\StructType\Facilities $facilities = null)
    {
        $this->Facilities = $facilities;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedVehicleJourneyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
