<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedStopPlaceStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the Stop Places affected by an SITUATION.
 * @subpackage Structs
 */
class AffectedStopPlaceStructure extends AffectedStopPlaceElementStructure
{
    /**
     * The StopPlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Stop Place affected by SITUATION.
     * @var \StructType\StopPlaceRefStructure
     */
    public $StopPlaceRef;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Name of stop place. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PlaceName;
    /**
     * The StopPlaceType
     * Meta informations extracted from the WSDL
     * - documentation: Type of Stop Place.
     * - minOccurs: 0
     * @var string
     */
    public $StopPlaceType;
    /**
     * The AffectedFacilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AffectedFacilities
     */
    public $AffectedFacilities;
    /**
     * The AffectedComponents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AffectedComponents
     */
    public $AffectedComponents;
    /**
     * The AffectedNavigationPaths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AffectedNavigationPaths
     */
    public $AffectedNavigationPaths;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedStopPlaceStructure
     * @uses AffectedStopPlaceStructure::setStopPlaceRef()
     * @uses AffectedStopPlaceStructure::setPlaceName()
     * @uses AffectedStopPlaceStructure::setStopPlaceType()
     * @uses AffectedStopPlaceStructure::setAffectedFacilities()
     * @uses AffectedStopPlaceStructure::setAffectedComponents()
     * @uses AffectedStopPlaceStructure::setAffectedNavigationPaths()
     * @uses AffectedStopPlaceStructure::setExtensions()
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @param string $stopPlaceType
     * @param \StructType\AffectedFacilities $affectedFacilities
     * @param \StructType\AffectedComponents $affectedComponents
     * @param \StructType\AffectedNavigationPaths $affectedNavigationPaths
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPlaceRefStructure $stopPlaceRef = null, array $placeName = array(), $stopPlaceType = null, \StructType\AffectedFacilities $affectedFacilities = null, \StructType\AffectedComponents $affectedComponents = null, \StructType\AffectedNavigationPaths $affectedNavigationPaths = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStopPlaceRef($stopPlaceRef)
            ->setPlaceName($placeName)
            ->setStopPlaceType($stopPlaceType)
            ->setAffectedFacilities($affectedFacilities)
            ->setAffectedComponents($affectedComponents)
            ->setAffectedNavigationPaths($affectedNavigationPaths)
            ->setExtensions($extensions);
    }
    /**
     * Get StopPlaceRef value
     * @return \StructType\StopPlaceRefStructure|null
     */
    public function getStopPlaceRef()
    {
        return $this->StopPlaceRef;
    }
    /**
     * Set StopPlaceRef value
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setStopPlaceRef(\StructType\StopPlaceRefStructure $stopPlaceRef = null)
    {
        $this->StopPlaceRef = $stopPlaceRef;
        return $this;
    }
    /**
     * Get PlaceName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPlaceName()
    {
        return $this->PlaceName;
    }
    /**
     * Set PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setPlaceName(array $placeName = array())
    {
        foreach ($placeName as $affectedStopPlaceStructurePlaceNameItem) {
            // validation for constraint: itemType
            if (!$affectedStopPlaceStructurePlaceNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedStopPlaceStructurePlaceNameItem) ? get_class($affectedStopPlaceStructurePlaceNameItem) : gettype($affectedStopPlaceStructurePlaceNameItem)), __LINE__);
            }
        }
        $this->PlaceName = $placeName;
        return $this;
    }
    /**
     * Add item to PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function addToPlaceName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceName[] = $item;
        return $this;
    }
    /**
     * Get StopPlaceType value
     * @return string|null
     */
    public function getStopPlaceType()
    {
        return $this->StopPlaceType;
    }
    /**
     * Set StopPlaceType value
     * @uses \EnumType\StopPlaceTypeEnumeration::valueIsValid()
     * @uses \EnumType\StopPlaceTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopPlaceType
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setStopPlaceType($stopPlaceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopPlaceTypeEnumeration::valueIsValid($stopPlaceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopPlaceType, implode(', ', \EnumType\StopPlaceTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->StopPlaceType = $stopPlaceType;
        return $this;
    }
    /**
     * Get AffectedFacilities value
     * @return \StructType\AffectedFacilities|null
     */
    public function getAffectedFacilities()
    {
        return $this->AffectedFacilities;
    }
    /**
     * Set AffectedFacilities value
     * @param \StructType\AffectedFacilities $affectedFacilities
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setAffectedFacilities(\StructType\AffectedFacilities $affectedFacilities = null)
    {
        $this->AffectedFacilities = $affectedFacilities;
        return $this;
    }
    /**
     * Get AffectedComponents value
     * @return \StructType\AffectedComponents|null
     */
    public function getAffectedComponents()
    {
        return $this->AffectedComponents;
    }
    /**
     * Set AffectedComponents value
     * @param \StructType\AffectedComponents $affectedComponents
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setAffectedComponents(\StructType\AffectedComponents $affectedComponents = null)
    {
        $this->AffectedComponents = $affectedComponents;
        return $this;
    }
    /**
     * Get AffectedNavigationPaths value
     * @return \StructType\AffectedNavigationPaths|null
     */
    public function getAffectedNavigationPaths()
    {
        return $this->AffectedNavigationPaths;
    }
    /**
     * Set AffectedNavigationPaths value
     * @param \StructType\AffectedNavigationPaths $affectedNavigationPaths
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setAffectedNavigationPaths(\StructType\AffectedNavigationPaths $affectedNavigationPaths = null)
    {
        $this->AffectedNavigationPaths = $affectedNavigationPaths;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedStopPlaceStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedStopPlaceStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
