<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedStopPlaceComponentStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the quays affected by an SITUATION.
 * @subpackage Structs
 */
class AffectedStopPlaceComponentStructure extends AffectedStopPlaceElementStructure
{
    /**
     * The ComponentRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a Stop Place.
     * @var \StructType\StopPlaceComponentRefStructure
     */
    public $ComponentRef;
    /**
     * The ComponentName
     * Meta informations extracted from the WSDL
     * - documentation: Name of component. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $ComponentName;
    /**
     * The ComponentType
     * Meta informations extracted from the WSDL
     * - documentation: Type of Component.
     * - minOccurs: 0
     * @var string
     */
    public $ComponentType;
    /**
     * The PointProjection
     * @var \StructType\PointProjectionStructure
     */
    public $PointProjection;
    /**
     * The LinkProjection
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjection;
    /**
     * The ZoneProjection
     * @var \StructType\ZoneProjectionStructure
     */
    public $ZoneProjection;
    /**
     * The Offset
     * Meta informations extracted from the WSDL
     * - documentation: Further qualifcation of affected part of Link projection,
     * - minOccurs: 0
     * @var \StructType\OffsetStructure
     */
    public $Offset;
    /**
     * The AccessFeatureType
     * Meta informations extracted from the WSDL
     * - documentation: Type of AccessFeature (+SIRI.20)
     * - minOccurs: 0
     * @var string
     */
    public $AccessFeatureType;
    /**
     * The AffectedFacilities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AffectedFacilities
     */
    public $AffectedFacilities;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedStopPlaceComponentStructure
     * @uses AffectedStopPlaceComponentStructure::setComponentRef()
     * @uses AffectedStopPlaceComponentStructure::setComponentName()
     * @uses AffectedStopPlaceComponentStructure::setComponentType()
     * @uses AffectedStopPlaceComponentStructure::setPointProjection()
     * @uses AffectedStopPlaceComponentStructure::setLinkProjection()
     * @uses AffectedStopPlaceComponentStructure::setZoneProjection()
     * @uses AffectedStopPlaceComponentStructure::setOffset()
     * @uses AffectedStopPlaceComponentStructure::setAccessFeatureType()
     * @uses AffectedStopPlaceComponentStructure::setAffectedFacilities()
     * @uses AffectedStopPlaceComponentStructure::setExtensions()
     * @param \StructType\StopPlaceComponentRefStructure $componentRef
     * @param \StructType\NaturalLanguageStringStructure[] $componentName
     * @param string $componentType
     * @param \StructType\PointProjectionStructure $pointProjection
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @param \StructType\ZoneProjectionStructure $zoneProjection
     * @param \StructType\OffsetStructure $offset
     * @param string $accessFeatureType
     * @param \StructType\AffectedFacilities $affectedFacilities
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPlaceComponentRefStructure $componentRef = null, array $componentName = array(), $componentType = null, \StructType\PointProjectionStructure $pointProjection = null, \StructType\LinkProjectionStructure $linkProjection = null, \StructType\ZoneProjectionStructure $zoneProjection = null, \StructType\OffsetStructure $offset = null, $accessFeatureType = null, \StructType\AffectedFacilities $affectedFacilities = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setComponentRef($componentRef)
            ->setComponentName($componentName)
            ->setComponentType($componentType)
            ->setPointProjection($pointProjection)
            ->setLinkProjection($linkProjection)
            ->setZoneProjection($zoneProjection)
            ->setOffset($offset)
            ->setAccessFeatureType($accessFeatureType)
            ->setAffectedFacilities($affectedFacilities)
            ->setExtensions($extensions);
    }
    /**
     * Get ComponentRef value
     * @return \StructType\StopPlaceComponentRefStructure|null
     */
    public function getComponentRef()
    {
        return $this->ComponentRef;
    }
    /**
     * Set ComponentRef value
     * @param \StructType\StopPlaceComponentRefStructure $componentRef
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setComponentRef(\StructType\StopPlaceComponentRefStructure $componentRef = null)
    {
        $this->ComponentRef = $componentRef;
        return $this;
    }
    /**
     * Get ComponentName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getComponentName()
    {
        return $this->ComponentName;
    }
    /**
     * Set ComponentName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $componentName
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setComponentName(array $componentName = array())
    {
        foreach ($componentName as $affectedStopPlaceComponentStructureComponentNameItem) {
            // validation for constraint: itemType
            if (!$affectedStopPlaceComponentStructureComponentNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The ComponentName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedStopPlaceComponentStructureComponentNameItem) ? get_class($affectedStopPlaceComponentStructureComponentNameItem) : gettype($affectedStopPlaceComponentStructureComponentNameItem)), __LINE__);
            }
        }
        $this->ComponentName = $componentName;
        return $this;
    }
    /**
     * Add item to ComponentName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function addToComponentName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The ComponentName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ComponentName[] = $item;
        return $this;
    }
    /**
     * Get ComponentType value
     * @return string|null
     */
    public function getComponentType()
    {
        return $this->ComponentType;
    }
    /**
     * Set ComponentType value
     * @uses \EnumType\StopPlaceComponentTypeEnumeration::valueIsValid()
     * @uses \EnumType\StopPlaceComponentTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $componentType
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setComponentType($componentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopPlaceComponentTypeEnumeration::valueIsValid($componentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $componentType, implode(', ', \EnumType\StopPlaceComponentTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->ComponentType = $componentType;
        return $this;
    }
    /**
     * Get PointProjection value
     * @return \StructType\PointProjectionStructure|null
     */
    public function getPointProjection()
    {
        return $this->PointProjection;
    }
    /**
     * Set PointProjection value
     * @param \StructType\PointProjectionStructure $pointProjection
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setPointProjection(\StructType\PointProjectionStructure $pointProjection = null)
    {
        $this->PointProjection = $pointProjection;
        return $this;
    }
    /**
     * Get LinkProjection value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjection()
    {
        return $this->LinkProjection;
    }
    /**
     * Set LinkProjection value
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setLinkProjection(\StructType\LinkProjectionStructure $linkProjection = null)
    {
        $this->LinkProjection = $linkProjection;
        return $this;
    }
    /**
     * Get ZoneProjection value
     * @return \StructType\ZoneProjectionStructure|null
     */
    public function getZoneProjection()
    {
        return $this->ZoneProjection;
    }
    /**
     * Set ZoneProjection value
     * @param \StructType\ZoneProjectionStructure $zoneProjection
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setZoneProjection(\StructType\ZoneProjectionStructure $zoneProjection = null)
    {
        $this->ZoneProjection = $zoneProjection;
        return $this;
    }
    /**
     * Get Offset value
     * @return \StructType\OffsetStructure|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param \StructType\OffsetStructure $offset
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setOffset(\StructType\OffsetStructure $offset = null)
    {
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get AccessFeatureType value
     * @return string|null
     */
    public function getAccessFeatureType()
    {
        return $this->AccessFeatureType;
    }
    /**
     * Set AccessFeatureType value
     * @uses \EnumType\AccessibilityFeatureEnumeration::valueIsValid()
     * @uses \EnumType\AccessibilityFeatureEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessFeatureType
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setAccessFeatureType($accessFeatureType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessibilityFeatureEnumeration::valueIsValid($accessFeatureType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessFeatureType, implode(', ', \EnumType\AccessibilityFeatureEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessFeatureType = $accessFeatureType;
        return $this;
    }
    /**
     * Get AffectedFacilities value
     * @return \StructType\AffectedFacilities|null
     */
    public function getAffectedFacilities()
    {
        return $this->AffectedFacilities;
    }
    /**
     * Set AffectedFacilities value
     * @param \StructType\AffectedFacilities $affectedFacilities
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setAffectedFacilities(\StructType\AffectedFacilities $affectedFacilities = null)
    {
        $this->AffectedFacilities = $affectedFacilities;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedStopPlaceComponentStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
