<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedOperatorStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Annotated reference to an OPERATOR affected by a SITUATION.
 * @subpackage Structs
 */
class AffectedOperatorStructure extends AbstractStructBase
{
    /**
     * The OperatorRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to an OPERATOR.
     * - minOccurs: 0
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The OperatorName
     * Meta informations extracted from the WSDL
     * - documentation: Public Name of OPERATOR. Can be derived from OperatorRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $OperatorName;
    /**
     * The OperatorShortName
     * Meta informations extracted from the WSDL
     * - documentation: Short Name for OPERATOR. Can be derived from OperatorRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $OperatorShortName;
    /**
     * The OperationalUnitRef
     * Meta informations extracted from the WSDL
     * - documentation: OPERATIONAL UNIT responsible for managing services.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OperationalUnitRefStructure[]
     */
    public $OperationalUnitRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedOperatorStructure
     * @uses AffectedOperatorStructure::setOperatorRef()
     * @uses AffectedOperatorStructure::setOperatorName()
     * @uses AffectedOperatorStructure::setOperatorShortName()
     * @uses AffectedOperatorStructure::setOperationalUnitRef()
     * @uses AffectedOperatorStructure::setExtensions()
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\NaturalLanguageStringStructure[] $operatorName
     * @param \StructType\NaturalLanguageStringStructure[] $operatorShortName
     * @param \StructType\OperationalUnitRefStructure[] $operationalUnitRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\OperatorRefStructure $operatorRef = null, array $operatorName = array(), array $operatorShortName = array(), array $operationalUnitRef = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setOperatorRef($operatorRef)
            ->setOperatorName($operatorName)
            ->setOperatorShortName($operatorShortName)
            ->setOperationalUnitRef($operationalUnitRef)
            ->setExtensions($extensions);
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\AffectedOperatorStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get OperatorName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getOperatorName()
    {
        return $this->OperatorName;
    }
    /**
     * Set OperatorName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $operatorName
     * @return \StructType\AffectedOperatorStructure
     */
    public function setOperatorName(array $operatorName = array())
    {
        foreach ($operatorName as $affectedOperatorStructureOperatorNameItem) {
            // validation for constraint: itemType
            if (!$affectedOperatorStructureOperatorNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The OperatorName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedOperatorStructureOperatorNameItem) ? get_class($affectedOperatorStructureOperatorNameItem) : gettype($affectedOperatorStructureOperatorNameItem)), __LINE__);
            }
        }
        $this->OperatorName = $operatorName;
        return $this;
    }
    /**
     * Add item to OperatorName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedOperatorStructure
     */
    public function addToOperatorName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The OperatorName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperatorName[] = $item;
        return $this;
    }
    /**
     * Get OperatorShortName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getOperatorShortName()
    {
        return $this->OperatorShortName;
    }
    /**
     * Set OperatorShortName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $operatorShortName
     * @return \StructType\AffectedOperatorStructure
     */
    public function setOperatorShortName(array $operatorShortName = array())
    {
        foreach ($operatorShortName as $affectedOperatorStructureOperatorShortNameItem) {
            // validation for constraint: itemType
            if (!$affectedOperatorStructureOperatorShortNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The OperatorShortName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedOperatorStructureOperatorShortNameItem) ? get_class($affectedOperatorStructureOperatorShortNameItem) : gettype($affectedOperatorStructureOperatorShortNameItem)), __LINE__);
            }
        }
        $this->OperatorShortName = $operatorShortName;
        return $this;
    }
    /**
     * Add item to OperatorShortName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedOperatorStructure
     */
    public function addToOperatorShortName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The OperatorShortName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperatorShortName[] = $item;
        return $this;
    }
    /**
     * Get OperationalUnitRef value
     * @return \StructType\OperationalUnitRefStructure[]|null
     */
    public function getOperationalUnitRef()
    {
        return $this->OperationalUnitRef;
    }
    /**
     * Set OperationalUnitRef value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationalUnitRefStructure[] $operationalUnitRef
     * @return \StructType\AffectedOperatorStructure
     */
    public function setOperationalUnitRef(array $operationalUnitRef = array())
    {
        foreach ($operationalUnitRef as $affectedOperatorStructureOperationalUnitRefItem) {
            // validation for constraint: itemType
            if (!$affectedOperatorStructureOperationalUnitRefItem instanceof \StructType\OperationalUnitRefStructure) {
                throw new \InvalidArgumentException(sprintf('The OperationalUnitRef property can only contain items of \StructType\OperationalUnitRefStructure, "%s" given', is_object($affectedOperatorStructureOperationalUnitRefItem) ? get_class($affectedOperatorStructureOperationalUnitRefItem) : gettype($affectedOperatorStructureOperationalUnitRefItem)), __LINE__);
            }
        }
        $this->OperationalUnitRef = $operationalUnitRef;
        return $this;
    }
    /**
     * Add item to OperationalUnitRef value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationalUnitRefStructure $item
     * @return \StructType\AffectedOperatorStructure
     */
    public function addToOperationalUnitRef(\StructType\OperationalUnitRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperationalUnitRefStructure) {
            throw new \InvalidArgumentException(sprintf('The OperationalUnitRef property can only contain items of \StructType\OperationalUnitRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperationalUnitRef[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedOperatorStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedOperatorStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
