<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedNetworkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the parts of the network affected by an incident. If not explclitly overrided Modes and submodes will be defaulted to any values present in the general Context.
 * @subpackage Structs
 */
class AffectedNetworkStructure extends AbstractStructBase
{
    /**
     * The AffectedOperator
     * Meta informations extracted from the WSDL
     * - documentation: Operators of LINEs affected by incident. Overrides any value specified for (i) General Context.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedOperatorStructure[]
     */
    public $AffectedOperator;
    /**
     * The NetworkRef
     * Meta informations extracted from the WSDL
     * - documentation: Network of affected LINE. If absent, may be taken from context.
     * - minOccurs: 0
     * @var \StructType\NetworkRefStructure
     */
    public $NetworkRef;
    /**
     * The NetworkName
     * Meta informations extracted from the WSDL
     * - documentation: Name of Network. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $NetworkName;
    /**
     * The RoutesAffected
     * Meta informations extracted from the WSDL
     * - documentation: Textual description of overall routes affected. Should correspond to any structured description in the AffectedLines element. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $RoutesAffected;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The AirSubmode
     * @var string
     */
    public $AirSubmode;
    /**
     * The BusSubmode
     * @var string
     */
    public $BusSubmode;
    /**
     * The CoachSubmode
     * @var string
     */
    public $CoachSubmode;
    /**
     * The MetroSubmode
     * @var string
     */
    public $MetroSubmode;
    /**
     * The RailSubmode
     * @var string
     */
    public $RailSubmode;
    /**
     * The TramSubmode
     * @var string
     */
    public $TramSubmode;
    /**
     * The WaterSubmode
     * @var string
     */
    public $WaterSubmode;
    /**
     * The AccessMode
     * @var string
     */
    public $AccessMode;
    /**
     * The AllLines
     * Meta informations extracted from the WSDL
     * - documentation: All LINEs in the network are affected.
     * @var string
     */
    public $AllLines;
    /**
     * The SelectedRoutes
     * Meta informations extracted from the WSDL
     * - documentation: Only some ROUTEs are affected, LINE level information not available. See the AffectedRoutes element for textual description.
     * @var string
     */
    public $SelectedRoutes;
    /**
     * The AffectedLine
     * Meta informations extracted from the WSDL
     * - documentation: Information about the indvidual LINEs in the network that are affected. If not explclitly overrided Modes and submodes will be defaulted to any values present (i) in the AffectedNetwork (ii) In the general Context.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedLineStructure[]
     */
    public $AffectedLine;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedNetworkStructure
     * @uses AffectedNetworkStructure::setAffectedOperator()
     * @uses AffectedNetworkStructure::setNetworkRef()
     * @uses AffectedNetworkStructure::setNetworkName()
     * @uses AffectedNetworkStructure::setRoutesAffected()
     * @uses AffectedNetworkStructure::setVehicleMode()
     * @uses AffectedNetworkStructure::setAirSubmode()
     * @uses AffectedNetworkStructure::setBusSubmode()
     * @uses AffectedNetworkStructure::setCoachSubmode()
     * @uses AffectedNetworkStructure::setMetroSubmode()
     * @uses AffectedNetworkStructure::setRailSubmode()
     * @uses AffectedNetworkStructure::setTramSubmode()
     * @uses AffectedNetworkStructure::setWaterSubmode()
     * @uses AffectedNetworkStructure::setAccessMode()
     * @uses AffectedNetworkStructure::setAllLines()
     * @uses AffectedNetworkStructure::setSelectedRoutes()
     * @uses AffectedNetworkStructure::setAffectedLine()
     * @uses AffectedNetworkStructure::setExtensions()
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     * @param \StructType\NetworkRefStructure $networkRef
     * @param \StructType\NaturalLanguageStringStructure[] $networkName
     * @param \StructType\NaturalLanguageStringStructure[] $routesAffected
     * @param string $vehicleMode
     * @param string $airSubmode
     * @param string $busSubmode
     * @param string $coachSubmode
     * @param string $metroSubmode
     * @param string $railSubmode
     * @param string $tramSubmode
     * @param string $waterSubmode
     * @param string $accessMode
     * @param string $allLines
     * @param string $selectedRoutes
     * @param \StructType\AffectedLineStructure[] $affectedLine
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $affectedOperator = array(), \StructType\NetworkRefStructure $networkRef = null, array $networkName = array(), array $routesAffected = array(), $vehicleMode = null, $airSubmode = null, $busSubmode = null, $coachSubmode = null, $metroSubmode = null, $railSubmode = null, $tramSubmode = null, $waterSubmode = null, $accessMode = null, $allLines = null, $selectedRoutes = null, array $affectedLine = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setAffectedOperator($affectedOperator)
            ->setNetworkRef($networkRef)
            ->setNetworkName($networkName)
            ->setRoutesAffected($routesAffected)
            ->setVehicleMode($vehicleMode)
            ->setAirSubmode($airSubmode)
            ->setBusSubmode($busSubmode)
            ->setCoachSubmode($coachSubmode)
            ->setMetroSubmode($metroSubmode)
            ->setRailSubmode($railSubmode)
            ->setTramSubmode($tramSubmode)
            ->setWaterSubmode($waterSubmode)
            ->setAccessMode($accessMode)
            ->setAllLines($allLines)
            ->setSelectedRoutes($selectedRoutes)
            ->setAffectedLine($affectedLine)
            ->setExtensions($extensions);
    }
    /**
     * Get AffectedOperator value
     * @return \StructType\AffectedOperatorStructure[]|null
     */
    public function getAffectedOperator()
    {
        return $this->AffectedOperator;
    }
    /**
     * Set AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     * @return \StructType\AffectedNetworkStructure
     */
    public function setAffectedOperator(array $affectedOperator = array())
    {
        foreach ($affectedOperator as $affectedNetworkStructureAffectedOperatorItem) {
            // validation for constraint: itemType
            if (!$affectedNetworkStructureAffectedOperatorItem instanceof \StructType\AffectedOperatorStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($affectedNetworkStructureAffectedOperatorItem) ? get_class($affectedNetworkStructureAffectedOperatorItem) : gettype($affectedNetworkStructureAffectedOperatorItem)), __LINE__);
            }
        }
        $this->AffectedOperator = $affectedOperator;
        return $this;
    }
    /**
     * Add item to AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure $item
     * @return \StructType\AffectedNetworkStructure
     */
    public function addToAffectedOperator(\StructType\AffectedOperatorStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOperatorStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedOperator[] = $item;
        return $this;
    }
    /**
     * Get NetworkRef value
     * @return \StructType\NetworkRefStructure|null
     */
    public function getNetworkRef()
    {
        return $this->NetworkRef;
    }
    /**
     * Set NetworkRef value
     * @param \StructType\NetworkRefStructure $networkRef
     * @return \StructType\AffectedNetworkStructure
     */
    public function setNetworkRef(\StructType\NetworkRefStructure $networkRef = null)
    {
        $this->NetworkRef = $networkRef;
        return $this;
    }
    /**
     * Get NetworkName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getNetworkName()
    {
        return $this->NetworkName;
    }
    /**
     * Set NetworkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $networkName
     * @return \StructType\AffectedNetworkStructure
     */
    public function setNetworkName(array $networkName = array())
    {
        foreach ($networkName as $affectedNetworkStructureNetworkNameItem) {
            // validation for constraint: itemType
            if (!$affectedNetworkStructureNetworkNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The NetworkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedNetworkStructureNetworkNameItem) ? get_class($affectedNetworkStructureNetworkNameItem) : gettype($affectedNetworkStructureNetworkNameItem)), __LINE__);
            }
        }
        $this->NetworkName = $networkName;
        return $this;
    }
    /**
     * Add item to NetworkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedNetworkStructure
     */
    public function addToNetworkName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The NetworkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NetworkName[] = $item;
        return $this;
    }
    /**
     * Get RoutesAffected value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getRoutesAffected()
    {
        return $this->RoutesAffected;
    }
    /**
     * Set RoutesAffected value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $routesAffected
     * @return \StructType\AffectedNetworkStructure
     */
    public function setRoutesAffected(array $routesAffected = array())
    {
        foreach ($routesAffected as $affectedNetworkStructureRoutesAffectedItem) {
            // validation for constraint: itemType
            if (!$affectedNetworkStructureRoutesAffectedItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The RoutesAffected property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedNetworkStructureRoutesAffectedItem) ? get_class($affectedNetworkStructureRoutesAffectedItem) : gettype($affectedNetworkStructureRoutesAffectedItem)), __LINE__);
            }
        }
        $this->RoutesAffected = $routesAffected;
        return $this;
    }
    /**
     * Add item to RoutesAffected value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedNetworkStructure
     */
    public function addToRoutesAffected(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The RoutesAffected property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoutesAffected[] = $item;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesOfTransportEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get AirSubmode value
     * @return string|null
     */
    public function getAirSubmode()
    {
        return $this->AirSubmode;
    }
    /**
     * Set AirSubmode value
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setAirSubmode($airSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirSubmodesOfTransportEnumeration::valueIsValid($airSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airSubmode, implode(', ', \EnumType\AirSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->AirSubmode = $airSubmode;
        return $this;
    }
    /**
     * Get BusSubmode value
     * @return string|null
     */
    public function getBusSubmode()
    {
        return $this->BusSubmode;
    }
    /**
     * Set BusSubmode value
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setBusSubmode($busSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusSubmodesOfTransportEnumeration::valueIsValid($busSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busSubmode, implode(', ', \EnumType\BusSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->BusSubmode = $busSubmode;
        return $this;
    }
    /**
     * Get CoachSubmode value
     * @return string|null
     */
    public function getCoachSubmode()
    {
        return $this->CoachSubmode;
    }
    /**
     * Set CoachSubmode value
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $coachSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setCoachSubmode($coachSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid($coachSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $coachSubmode, implode(', ', \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->CoachSubmode = $coachSubmode;
        return $this;
    }
    /**
     * Get MetroSubmode value
     * @return string|null
     */
    public function getMetroSubmode()
    {
        return $this->MetroSubmode;
    }
    /**
     * Set MetroSubmode value
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $metroSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setMetroSubmode($metroSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid($metroSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $metroSubmode, implode(', ', \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->MetroSubmode = $metroSubmode;
        return $this;
    }
    /**
     * Get RailSubmode value
     * @return string|null
     */
    public function getRailSubmode()
    {
        return $this->RailSubmode;
    }
    /**
     * Set RailSubmode value
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setRailSubmode($railSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RailSubmodesOfTransportEnumeration::valueIsValid($railSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $railSubmode, implode(', ', \EnumType\RailSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->RailSubmode = $railSubmode;
        return $this;
    }
    /**
     * Get TramSubmode value
     * @return string|null
     */
    public function getTramSubmode()
    {
        return $this->TramSubmode;
    }
    /**
     * Set TramSubmode value
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tramSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setTramSubmode($tramSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TramSubmodesOfTransportEnumeration::valueIsValid($tramSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tramSubmode, implode(', ', \EnumType\TramSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->TramSubmode = $tramSubmode;
        return $this;
    }
    /**
     * Get WaterSubmode value
     * @return string|null
     */
    public function getWaterSubmode()
    {
        return $this->WaterSubmode;
    }
    /**
     * Set WaterSubmode value
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waterSubmode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setWaterSubmode($waterSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid($waterSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $waterSubmode, implode(', ', \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->WaterSubmode = $waterSubmode;
        return $this;
    }
    /**
     * Get AccessMode value
     * @return string|null
     */
    public function getAccessMode()
    {
        return $this->AccessMode;
    }
    /**
     * Set AccessMode value
     * @uses \EnumType\AccessModesEnumeration::valueIsValid()
     * @uses \EnumType\AccessModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessMode
     * @return \StructType\AffectedNetworkStructure
     */
    public function setAccessMode($accessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessModesEnumeration::valueIsValid($accessMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessMode, implode(', ', \EnumType\AccessModesEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessMode = $accessMode;
        return $this;
    }
    /**
     * Get AllLines value
     * @return string|null
     */
    public function getAllLines()
    {
        return $this->AllLines;
    }
    /**
     * Set AllLines value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allLines
     * @return \StructType\AffectedNetworkStructure
     */
    public function setAllLines($allLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($allLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allLines, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->AllLines = $allLines;
        return $this;
    }
    /**
     * Get SelectedRoutes value
     * @return string|null
     */
    public function getSelectedRoutes()
    {
        return $this->SelectedRoutes;
    }
    /**
     * Set SelectedRoutes value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectedRoutes
     * @return \StructType\AffectedNetworkStructure
     */
    public function setSelectedRoutes($selectedRoutes = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($selectedRoutes)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectedRoutes, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->SelectedRoutes = $selectedRoutes;
        return $this;
    }
    /**
     * Get AffectedLine value
     * @return \StructType\AffectedLineStructure[]|null
     */
    public function getAffectedLine()
    {
        return $this->AffectedLine;
    }
    /**
     * Set AffectedLine value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedLineStructure[] $affectedLine
     * @return \StructType\AffectedNetworkStructure
     */
    public function setAffectedLine(array $affectedLine = array())
    {
        foreach ($affectedLine as $affectedNetworkStructureAffectedLineItem) {
            // validation for constraint: itemType
            if (!$affectedNetworkStructureAffectedLineItem instanceof \StructType\AffectedLineStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedLine property can only contain items of \StructType\AffectedLineStructure, "%s" given', is_object($affectedNetworkStructureAffectedLineItem) ? get_class($affectedNetworkStructureAffectedLineItem) : gettype($affectedNetworkStructureAffectedLineItem)), __LINE__);
            }
        }
        $this->AffectedLine = $affectedLine;
        return $this;
    }
    /**
     * Add item to AffectedLine value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedLineStructure $item
     * @return \StructType\AffectedNetworkStructure
     */
    public function addToAffectedLine(\StructType\AffectedLineStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedLineStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedLine property can only contain items of \StructType\AffectedLineStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedLine[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedNetworkStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedNetworkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
