<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedModesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for TRANSPORT MODEs affecetd by a SITUATION.
 * @subpackage Structs
 */
class AffectedModesStructure extends AbstractStructBase
{
    /**
     * The AllModes
     * Meta informations extracted from the WSDL
     * - documentation: All known modes for stop.
     * - minOccurs: 0
     * @var string
     */
    public $AllModes;
    /**
     * The Mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mode[]
     */
    public $Mode;
    /**
     * Constructor method for AffectedModesStructure
     * @uses AffectedModesStructure::setAllModes()
     * @uses AffectedModesStructure::setMode()
     * @param string $allModes
     * @param \StructType\Mode[] $mode
     */
    public function __construct($allModes = null, array $mode = array())
    {
        $this
            ->setAllModes($allModes)
            ->setMode($mode);
    }
    /**
     * Get AllModes value
     * @return string|null
     */
    public function getAllModes()
    {
        return $this->AllModes;
    }
    /**
     * Set AllModes value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allModes
     * @return \StructType\AffectedModesStructure
     */
    public function setAllModes($allModes = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($allModes)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allModes, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->AllModes = $allModes;
        return $this;
    }
    /**
     * Get Mode value
     * @return \StructType\Mode[]|null
     */
    public function getMode()
    {
        return $this->Mode;
    }
    /**
     * Set Mode value
     * @throws \InvalidArgumentException
     * @param \StructType\Mode[] $mode
     * @return \StructType\AffectedModesStructure
     */
    public function setMode(array $mode = array())
    {
        foreach ($mode as $affectedModesStructureModeItem) {
            // validation for constraint: itemType
            if (!$affectedModesStructureModeItem instanceof \StructType\Mode) {
                throw new \InvalidArgumentException(sprintf('The Mode property can only contain items of \StructType\Mode, "%s" given', is_object($affectedModesStructureModeItem) ? get_class($affectedModesStructureModeItem) : gettype($affectedModesStructureModeItem)), __LINE__);
            }
        }
        $this->Mode = $mode;
        return $this;
    }
    /**
     * Add item to Mode value
     * @throws \InvalidArgumentException
     * @param \StructType\Mode $item
     * @return \StructType\AffectedModesStructure
     */
    public function addToMode(\StructType\Mode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mode) {
            throw new \InvalidArgumentException(sprintf('The Mode property can only contain items of \StructType\Mode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Mode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedModesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
