<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedLineStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the LINEs affected by a SITUATION.
 * @subpackage Structs
 */
class AffectedLineStructure extends AbstractStructBase
{
    /**
     * The AffectedOperator
     * Meta informations extracted from the WSDL
     * - documentation: Operators of LINEs affected by incident. Overrides any value specified for (i) Affected Network (ii) General Context.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedOperatorStructure[]
     */
    public $AffectedOperator;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - documentation: DESTINATIONs to which the LINE runs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedStopPointStructure[]
     */
    public $Destinations;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: DIRECTIONs affected.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DirectionStructure[]
     */
    public $Direction;
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Routes
     */
    public $Routes;
    /**
     * The Sections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sections
     */
    public $Sections;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedLineStructure
     * @uses AffectedLineStructure::setAffectedOperator()
     * @uses AffectedLineStructure::setLineRef()
     * @uses AffectedLineStructure::setPublishedLineName()
     * @uses AffectedLineStructure::setDestinations()
     * @uses AffectedLineStructure::setDirection()
     * @uses AffectedLineStructure::setRoutes()
     * @uses AffectedLineStructure::setSections()
     * @uses AffectedLineStructure::setExtensions()
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\AffectedStopPointStructure[] $destinations
     * @param \StructType\DirectionStructure[] $direction
     * @param \StructType\Routes $routes
     * @param \StructType\Sections $sections
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $affectedOperator = array(), \StructType\LineRefStructure $lineRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, array $destinations = array(), array $direction = array(), \StructType\Routes $routes = null, \StructType\Sections $sections = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setAffectedOperator($affectedOperator)
            ->setLineRef($lineRef)
            ->setPublishedLineName($publishedLineName)
            ->setDestinations($destinations)
            ->setDirection($direction)
            ->setRoutes($routes)
            ->setSections($sections)
            ->setExtensions($extensions);
    }
    /**
     * Get AffectedOperator value
     * @return \StructType\AffectedOperatorStructure[]|null
     */
    public function getAffectedOperator()
    {
        return $this->AffectedOperator;
    }
    /**
     * Set AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure[] $affectedOperator
     * @return \StructType\AffectedLineStructure
     */
    public function setAffectedOperator(array $affectedOperator = array())
    {
        foreach ($affectedOperator as $affectedLineStructureAffectedOperatorItem) {
            // validation for constraint: itemType
            if (!$affectedLineStructureAffectedOperatorItem instanceof \StructType\AffectedOperatorStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($affectedLineStructureAffectedOperatorItem) ? get_class($affectedLineStructureAffectedOperatorItem) : gettype($affectedLineStructureAffectedOperatorItem)), __LINE__);
            }
        }
        $this->AffectedOperator = $affectedOperator;
        return $this;
    }
    /**
     * Add item to AffectedOperator value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOperatorStructure $item
     * @return \StructType\AffectedLineStructure
     */
    public function addToAffectedOperator(\StructType\AffectedOperatorStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOperatorStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedOperator property can only contain items of \StructType\AffectedOperatorStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedOperator[] = $item;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\AffectedLineStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\AffectedLineStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \StructType\AffectedStopPointStructure[]|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure[] $destinations
     * @return \StructType\AffectedLineStructure
     */
    public function setDestinations(array $destinations = array())
    {
        foreach ($destinations as $affectedLineStructureDestinationsItem) {
            // validation for constraint: itemType
            if (!$affectedLineStructureDestinationsItem instanceof \StructType\AffectedStopPointStructure) {
                throw new \InvalidArgumentException(sprintf('The Destinations property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($affectedLineStructureDestinationsItem) ? get_class($affectedLineStructureDestinationsItem) : gettype($affectedLineStructureDestinationsItem)), __LINE__);
            }
        }
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Add item to Destinations value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedStopPointStructure $item
     * @return \StructType\AffectedLineStructure
     */
    public function addToDestinations(\StructType\AffectedStopPointStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedStopPointStructure) {
            throw new \InvalidArgumentException(sprintf('The Destinations property can only contain items of \StructType\AffectedStopPointStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Destinations[] = $item;
        return $this;
    }
    /**
     * Get Direction value
     * @return \StructType\DirectionStructure[]|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionStructure[] $direction
     * @return \StructType\AffectedLineStructure
     */
    public function setDirection(array $direction = array())
    {
        foreach ($direction as $affectedLineStructureDirectionItem) {
            // validation for constraint: itemType
            if (!$affectedLineStructureDirectionItem instanceof \StructType\DirectionStructure) {
                throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\DirectionStructure, "%s" given', is_object($affectedLineStructureDirectionItem) ? get_class($affectedLineStructureDirectionItem) : gettype($affectedLineStructureDirectionItem)), __LINE__);
            }
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Add item to Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionStructure $item
     * @return \StructType\AffectedLineStructure
     */
    public function addToDirection(\StructType\DirectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectionStructure) {
            throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\DirectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Direction[] = $item;
        return $this;
    }
    /**
     * Get Routes value
     * @return \StructType\Routes|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \StructType\Routes $routes
     * @return \StructType\AffectedLineStructure
     */
    public function setRoutes(\StructType\Routes $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get Sections value
     * @return \StructType\Sections|null
     */
    public function getSections()
    {
        return $this->Sections;
    }
    /**
     * Set Sections value
     * @param \StructType\Sections $sections
     * @return \StructType\AffectedLineStructure
     */
    public function setSections(\StructType\Sections $sections = null)
    {
        $this->Sections = $sections;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedLineStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedLineStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
