<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedInterchangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about a SERVICE JOURNEY INTERCHANGE at CONNECTION link from a given SCHEDULED STOP POINT.
 * @subpackage Structs
 */
class AffectedInterchangeStructure extends AbstractStructBase
{
    /**
     * The InterchangeRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a SERVICE JOURNEY INTERCHANGE affected by a SITUATION.
     * - minOccurs: 0
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The InterchangeStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of STOP POINT of a stop at which VEHICLE JOURNEY meets for interchange If blank, same stop as destination. | Reference to a STOP POINT.
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $InterchangeStopPointRef;
    /**
     * The InterchangeStopPointName
     * Meta informations extracted from the WSDL
     * - documentation: Name of other Connecting STOP POINT of a connection. Derivable from InterchangeStopRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $InterchangeStopPointName;
    /**
     * The ConnectingVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to connecting VEHICLE JOURNEY affected by a SITUATION.
     * - minOccurs: 0
     * @var \StructType\DatedVehicleJourneyRefStructure
     */
    public $ConnectingVehicleJourneyRef;
    /**
     * The InterchangeStatusType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: InterchangeStatusType
     * @var string
     */
    public $InterchangeStatusType;
    /**
     * The ConnectionLink
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a CONNECTION Link affected by a SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedConnectionLinkStructure[]
     */
    public $ConnectionLink;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedInterchangeStructure
     * @uses AffectedInterchangeStructure::setInterchangeRef()
     * @uses AffectedInterchangeStructure::setInterchangeStopPointRef()
     * @uses AffectedInterchangeStructure::setInterchangeStopPointName()
     * @uses AffectedInterchangeStructure::setConnectingVehicleJourneyRef()
     * @uses AffectedInterchangeStructure::setInterchangeStatusType()
     * @uses AffectedInterchangeStructure::setConnectionLink()
     * @uses AffectedInterchangeStructure::setExtensions()
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\StopPointRefStructure $interchangeStopPointRef
     * @param \StructType\NaturalLanguageStringStructure[] $interchangeStopPointName
     * @param \StructType\DatedVehicleJourneyRefStructure $connectingVehicleJourneyRef
     * @param string $interchangeStatusType
     * @param \StructType\AffectedConnectionLinkStructure[] $connectionLink
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\InterchangeRefStructure $interchangeRef = null, \StructType\StopPointRefStructure $interchangeStopPointRef = null, array $interchangeStopPointName = array(), \StructType\DatedVehicleJourneyRefStructure $connectingVehicleJourneyRef = null, $interchangeStatusType = null, array $connectionLink = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setInterchangeRef($interchangeRef)
            ->setInterchangeStopPointRef($interchangeStopPointRef)
            ->setInterchangeStopPointName($interchangeStopPointName)
            ->setConnectingVehicleJourneyRef($connectingVehicleJourneyRef)
            ->setInterchangeStatusType($interchangeStatusType)
            ->setConnectionLink($connectionLink)
            ->setExtensions($extensions);
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get InterchangeStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getInterchangeStopPointRef()
    {
        return $this->InterchangeStopPointRef;
    }
    /**
     * Set InterchangeStopPointRef value
     * @param \StructType\StopPointRefStructure $interchangeStopPointRef
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setInterchangeStopPointRef(\StructType\StopPointRefStructure $interchangeStopPointRef = null)
    {
        $this->InterchangeStopPointRef = $interchangeStopPointRef;
        return $this;
    }
    /**
     * Get InterchangeStopPointName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getInterchangeStopPointName()
    {
        return $this->InterchangeStopPointName;
    }
    /**
     * Set InterchangeStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $interchangeStopPointName
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setInterchangeStopPointName(array $interchangeStopPointName = array())
    {
        foreach ($interchangeStopPointName as $affectedInterchangeStructureInterchangeStopPointNameItem) {
            // validation for constraint: itemType
            if (!$affectedInterchangeStructureInterchangeStopPointNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The InterchangeStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedInterchangeStructureInterchangeStopPointNameItem) ? get_class($affectedInterchangeStructureInterchangeStopPointNameItem) : gettype($affectedInterchangeStructureInterchangeStopPointNameItem)), __LINE__);
            }
        }
        $this->InterchangeStopPointName = $interchangeStopPointName;
        return $this;
    }
    /**
     * Add item to InterchangeStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedInterchangeStructure
     */
    public function addToInterchangeStopPointName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The InterchangeStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InterchangeStopPointName[] = $item;
        return $this;
    }
    /**
     * Get ConnectingVehicleJourneyRef value
     * @return \StructType\DatedVehicleJourneyRefStructure|null
     */
    public function getConnectingVehicleJourneyRef()
    {
        return $this->ConnectingVehicleJourneyRef;
    }
    /**
     * Set ConnectingVehicleJourneyRef value
     * @param \StructType\DatedVehicleJourneyRefStructure $connectingVehicleJourneyRef
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setConnectingVehicleJourneyRef(\StructType\DatedVehicleJourneyRefStructure $connectingVehicleJourneyRef = null)
    {
        $this->ConnectingVehicleJourneyRef = $connectingVehicleJourneyRef;
        return $this;
    }
    /**
     * Get InterchangeStatusType value
     * @return string|null
     */
    public function getInterchangeStatusType()
    {
        return $this->InterchangeStatusType;
    }
    /**
     * Set InterchangeStatusType value
     * @uses \EnumType\InterchangeStatusEnumeration::valueIsValid()
     * @uses \EnumType\InterchangeStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interchangeStatusType
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setInterchangeStatusType($interchangeStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InterchangeStatusEnumeration::valueIsValid($interchangeStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $interchangeStatusType, implode(', ', \EnumType\InterchangeStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->InterchangeStatusType = $interchangeStatusType;
        return $this;
    }
    /**
     * Get ConnectionLink value
     * @return \StructType\AffectedConnectionLinkStructure[]|null
     */
    public function getConnectionLink()
    {
        return $this->ConnectionLink;
    }
    /**
     * Set ConnectionLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedConnectionLinkStructure[] $connectionLink
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setConnectionLink(array $connectionLink = array())
    {
        foreach ($connectionLink as $affectedInterchangeStructureConnectionLinkItem) {
            // validation for constraint: itemType
            if (!$affectedInterchangeStructureConnectionLinkItem instanceof \StructType\AffectedConnectionLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionLink property can only contain items of \StructType\AffectedConnectionLinkStructure, "%s" given', is_object($affectedInterchangeStructureConnectionLinkItem) ? get_class($affectedInterchangeStructureConnectionLinkItem) : gettype($affectedInterchangeStructureConnectionLinkItem)), __LINE__);
            }
        }
        $this->ConnectionLink = $connectionLink;
        return $this;
    }
    /**
     * Add item to ConnectionLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedConnectionLinkStructure $item
     * @return \StructType\AffectedInterchangeStructure
     */
    public function addToConnectionLink(\StructType\AffectedConnectionLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedConnectionLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLink property can only contain items of \StructType\AffectedConnectionLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionLink[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedInterchangeStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedInterchangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
