<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractTopicPermissionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Abstract Permission Topic.
 * @subpackage Structs
 */
class AbstractTopicPermissionStructure extends AbstractStructBase
{
    /**
     * The Allow
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether the participant may access this topic. Default is 'true'.
     * @var bool
     */
    public $Allow;
    /**
     * Constructor method for AbstractTopicPermissionStructure
     * @uses AbstractTopicPermissionStructure::setAllow()
     * @param bool $allow
     */
    public function __construct($allow = true)
    {
        $this
            ->setAllow($allow);
    }
    /**
     * Get Allow value
     * @return bool|null
     */
    public function getAllow()
    {
        return $this->Allow;
    }
    /**
     * Set Allow value
     * @param bool $allow
     * @return \StructType\AbstractTopicPermissionStructure
     */
    public function setAllow($allow = true)
    {
        // validation for constraint: boolean
        if (!is_null($allow) && !is_bool($allow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allow)), __LINE__);
        }
        $this->Allow = $allow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractTopicPermissionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
