<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractSubscriptionRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for COmmon Subscription Request.
 * @subpackage Structs
 */
abstract class AbstractSubscriptionRequestStructure extends RequestStructure
{
    /**
     * The ConsumerAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $ConsumerAddress;
    /**
     * The SubscriptionFilterIdentifier
     * @var string
     */
    public $SubscriptionFilterIdentifier;
    /**
     * The SubscriptionContext
     * Meta informations extracted from the WSDL
     * - documentation: General values that apply to subscription. Usually set by configuration.
     * - minOccurs: 0
     * @var \StructType\SubscriptionContextStructure
     */
    public $SubscriptionContext;
    /**
     * Constructor method for AbstractSubscriptionRequestStructure
     * @uses AbstractSubscriptionRequestStructure::setConsumerAddress()
     * @uses AbstractSubscriptionRequestStructure::setSubscriptionFilterIdentifier()
     * @uses AbstractSubscriptionRequestStructure::setSubscriptionContext()
     * @param string $consumerAddress
     * @param string $subscriptionFilterIdentifier
     * @param \StructType\SubscriptionContextStructure $subscriptionContext
     */
    public function __construct($consumerAddress = null, $subscriptionFilterIdentifier = null, \StructType\SubscriptionContextStructure $subscriptionContext = null)
    {
        $this
            ->setConsumerAddress($consumerAddress)
            ->setSubscriptionFilterIdentifier($subscriptionFilterIdentifier)
            ->setSubscriptionContext($subscriptionContext);
    }
    /**
     * Get ConsumerAddress value
     * @return string|null
     */
    public function getConsumerAddress()
    {
        return $this->ConsumerAddress;
    }
    /**
     * Set ConsumerAddress value
     * @param string $consumerAddress
     * @return \StructType\AbstractSubscriptionRequestStructure
     */
    public function setConsumerAddress($consumerAddress = null)
    {
        // validation for constraint: string
        if (!is_null($consumerAddress) && !is_string($consumerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consumerAddress)), __LINE__);
        }
        $this->ConsumerAddress = $consumerAddress;
        return $this;
    }
    /**
     * Get SubscriptionFilterIdentifier value
     * @return string|null
     */
    public function getSubscriptionFilterIdentifier()
    {
        return $this->SubscriptionFilterIdentifier;
    }
    /**
     * Set SubscriptionFilterIdentifier value
     * @param string $subscriptionFilterIdentifier
     * @return \StructType\AbstractSubscriptionRequestStructure
     */
    public function setSubscriptionFilterIdentifier($subscriptionFilterIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionFilterIdentifier) && !is_string($subscriptionFilterIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionFilterIdentifier)), __LINE__);
        }
        $this->SubscriptionFilterIdentifier = $subscriptionFilterIdentifier;
        return $this;
    }
    /**
     * Get SubscriptionContext value
     * @return \StructType\SubscriptionContextStructure|null
     */
    public function getSubscriptionContext()
    {
        return $this->SubscriptionContext;
    }
    /**
     * Set SubscriptionContext value
     * @param \StructType\SubscriptionContextStructure $subscriptionContext
     * @return \StructType\AbstractSubscriptionRequestStructure
     */
    public function setSubscriptionContext(\StructType\SubscriptionContextStructure $subscriptionContext = null)
    {
        $this->SubscriptionContext = $subscriptionContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractSubscriptionRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
