<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractSituationElementStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for abstract EntryAbstract type.
 * @subpackage Structs
 */
class AbstractSituationElementStructure extends AbstractStructBase
{
    /**
     * The CreationTime
     * Meta informations extracted from the WSDL
     * - documentation: Time of creation of SITUATION.
     * @var string
     */
    public $CreationTime;
    /**
     * The CountryRef
     * @var \StructType\CountryRefStructure
     */
    public $CountryRef;
    /**
     * The ParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ParticipantRef;
    /**
     * The SituationNumber
     * @var \StructType\EntryQualifierStructure
     */
    public $SituationNumber;
    /**
     * The UpdateCountryRef
     * @var \StructType\CountryRefStructure
     */
    public $UpdateCountryRef;
    /**
     * The UpdateParticipantRef
     * @var \StructType\ParticipantRefStructure
     */
    public $UpdateParticipantRef;
    /**
     * The Version
     * @var \StructType\SituationVersion
     */
    public $Version;
    /**
     * Constructor method for AbstractSituationElementStructure
     * @uses AbstractSituationElementStructure::setCreationTime()
     * @uses AbstractSituationElementStructure::setCountryRef()
     * @uses AbstractSituationElementStructure::setParticipantRef()
     * @uses AbstractSituationElementStructure::setSituationNumber()
     * @uses AbstractSituationElementStructure::setUpdateCountryRef()
     * @uses AbstractSituationElementStructure::setUpdateParticipantRef()
     * @uses AbstractSituationElementStructure::setVersion()
     * @param string $creationTime
     * @param \StructType\CountryRefStructure $countryRef
     * @param \StructType\ParticipantRefStructure $participantRef
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @param \StructType\SituationVersion $version
     */
    public function __construct($creationTime = null, \StructType\CountryRefStructure $countryRef = null, \StructType\ParticipantRefStructure $participantRef = null, \StructType\EntryQualifierStructure $situationNumber = null, \StructType\CountryRefStructure $updateCountryRef = null, \StructType\ParticipantRefStructure $updateParticipantRef = null, \StructType\SituationVersion $version = null)
    {
        $this
            ->setCreationTime($creationTime)
            ->setCountryRef($countryRef)
            ->setParticipantRef($participantRef)
            ->setSituationNumber($situationNumber)
            ->setUpdateCountryRef($updateCountryRef)
            ->setUpdateParticipantRef($updateParticipantRef)
            ->setVersion($version);
    }
    /**
     * Get CreationTime value
     * @return string|null
     */
    public function getCreationTime()
    {
        return $this->CreationTime;
    }
    /**
     * Set CreationTime value
     * @param string $creationTime
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setCreationTime($creationTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationTime) && !is_string($creationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationTime)), __LINE__);
        }
        $this->CreationTime = $creationTime;
        return $this;
    }
    /**
     * Get CountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getCountryRef()
    {
        return $this->CountryRef;
    }
    /**
     * Set CountryRef value
     * @param \StructType\CountryRefStructure $countryRef
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setCountryRef(\StructType\CountryRefStructure $countryRef = null)
    {
        $this->CountryRef = $countryRef;
        return $this;
    }
    /**
     * Get ParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getParticipantRef()
    {
        return $this->ParticipantRef;
    }
    /**
     * Set ParticipantRef value
     * @param \StructType\ParticipantRefStructure $participantRef
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setParticipantRef(\StructType\ParticipantRefStructure $participantRef = null)
    {
        $this->ParticipantRef = $participantRef;
        return $this;
    }
    /**
     * Get SituationNumber value
     * @return \StructType\EntryQualifierStructure|null
     */
    public function getSituationNumber()
    {
        return $this->SituationNumber;
    }
    /**
     * Set SituationNumber value
     * @param \StructType\EntryQualifierStructure $situationNumber
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setSituationNumber(\StructType\EntryQualifierStructure $situationNumber = null)
    {
        $this->SituationNumber = $situationNumber;
        return $this;
    }
    /**
     * Get UpdateCountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getUpdateCountryRef()
    {
        return $this->UpdateCountryRef;
    }
    /**
     * Set UpdateCountryRef value
     * @param \StructType\CountryRefStructure $updateCountryRef
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setUpdateCountryRef(\StructType\CountryRefStructure $updateCountryRef = null)
    {
        $this->UpdateCountryRef = $updateCountryRef;
        return $this;
    }
    /**
     * Get UpdateParticipantRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getUpdateParticipantRef()
    {
        return $this->UpdateParticipantRef;
    }
    /**
     * Set UpdateParticipantRef value
     * @param \StructType\ParticipantRefStructure $updateParticipantRef
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setUpdateParticipantRef(\StructType\ParticipantRefStructure $updateParticipantRef = null)
    {
        $this->UpdateParticipantRef = $updateParticipantRef;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\SituationVersion|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\SituationVersion $version
     * @return \StructType\AbstractSituationElementStructure
     */
    public function setVersion(\StructType\SituationVersion $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractSituationElementStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
