<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractDistributorItemStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an SERVICE JOURNEY INTERCHANGE Activity. | Elements identifying of a Distributor SERVICE JOURNEY INTERCHANGE.
 * @subpackage Structs
 */
class AbstractDistributorItemStructure extends AbstractItemStructure
{
    /**
     * The InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The DistributorVisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $DistributorVisitNumber;
    /**
     * The DistributorOrder
     * @var int
     */
    public $DistributorOrder;
    /**
     * The DistributorJourney
     * Meta informations extracted from the WSDL
     * - documentation: Information about the connecting Distributor (fetcher) VEHICLE JOURNEY.
     * @var \StructType\InterchangeJourneyStructure
     */
    public $DistributorJourney;
    /**
     * The FeederVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a feeder VEHICLE JOURNEY or journeys for which the Distributor (fetcher) will wait .
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FramedVehicleJourneyRefStructure[]
     */
    public $FeederVehicleJourneyRef;
    /**
     * Constructor method for AbstractDistributorItemStructure
     * @uses AbstractDistributorItemStructure::setInterchangeRef()
     * @uses AbstractDistributorItemStructure::setConnectionLinkRef()
     * @uses AbstractDistributorItemStructure::setStopPointRef()
     * @uses AbstractDistributorItemStructure::setDistributorVisitNumber()
     * @uses AbstractDistributorItemStructure::setDistributorOrder()
     * @uses AbstractDistributorItemStructure::setDistributorJourney()
     * @uses AbstractDistributorItemStructure::setFeederVehicleJourneyRef()
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $distributorVisitNumber
     * @param int $distributorOrder
     * @param \StructType\InterchangeJourneyStructure $distributorJourney
     * @param \StructType\FramedVehicleJourneyRefStructure[] $feederVehicleJourneyRef
     */
    public function __construct(\StructType\InterchangeRefStructure $interchangeRef = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\StopPointRefStructure $stopPointRef = null, $distributorVisitNumber = null, $distributorOrder = null, \StructType\InterchangeJourneyStructure $distributorJourney = null, array $feederVehicleJourneyRef = array())
    {
        $this
            ->setInterchangeRef($interchangeRef)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setStopPointRef($stopPointRef)
            ->setDistributorVisitNumber($distributorVisitNumber)
            ->setDistributorOrder($distributorOrder)
            ->setDistributorJourney($distributorJourney)
            ->setFeederVehicleJourneyRef($feederVehicleJourneyRef);
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get DistributorVisitNumber value
     * @return int|null
     */
    public function getDistributorVisitNumber()
    {
        return $this->DistributorVisitNumber;
    }
    /**
     * Set DistributorVisitNumber value
     * @param int $distributorVisitNumber
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setDistributorVisitNumber($distributorVisitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($distributorVisitNumber) && !is_numeric($distributorVisitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorVisitNumber)), __LINE__);
        }
        $this->DistributorVisitNumber = $distributorVisitNumber;
        return $this;
    }
    /**
     * Get DistributorOrder value
     * @return int|null
     */
    public function getDistributorOrder()
    {
        return $this->DistributorOrder;
    }
    /**
     * Set DistributorOrder value
     * @param int $distributorOrder
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setDistributorOrder($distributorOrder = null)
    {
        // validation for constraint: int
        if (!is_null($distributorOrder) && !is_numeric($distributorOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorOrder)), __LINE__);
        }
        $this->DistributorOrder = $distributorOrder;
        return $this;
    }
    /**
     * Get DistributorJourney value
     * @return \StructType\InterchangeJourneyStructure|null
     */
    public function getDistributorJourney()
    {
        return $this->DistributorJourney;
    }
    /**
     * Set DistributorJourney value
     * @param \StructType\InterchangeJourneyStructure $distributorJourney
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setDistributorJourney(\StructType\InterchangeJourneyStructure $distributorJourney = null)
    {
        $this->DistributorJourney = $distributorJourney;
        return $this;
    }
    /**
     * Get FeederVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure[]|null
     */
    public function getFeederVehicleJourneyRef()
    {
        return $this->FeederVehicleJourneyRef;
    }
    /**
     * Set FeederVehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FramedVehicleJourneyRefStructure[] $feederVehicleJourneyRef
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function setFeederVehicleJourneyRef(array $feederVehicleJourneyRef = array())
    {
        foreach ($feederVehicleJourneyRef as $abstractDistributorItemStructureFeederVehicleJourneyRefItem) {
            // validation for constraint: itemType
            if (!$abstractDistributorItemStructureFeederVehicleJourneyRefItem instanceof \StructType\FramedVehicleJourneyRefStructure) {
                throw new \InvalidArgumentException(sprintf('The FeederVehicleJourneyRef property can only contain items of \StructType\FramedVehicleJourneyRefStructure, "%s" given', is_object($abstractDistributorItemStructureFeederVehicleJourneyRefItem) ? get_class($abstractDistributorItemStructureFeederVehicleJourneyRefItem) : gettype($abstractDistributorItemStructureFeederVehicleJourneyRefItem)), __LINE__);
            }
        }
        $this->FeederVehicleJourneyRef = $feederVehicleJourneyRef;
        return $this;
    }
    /**
     * Add item to FeederVehicleJourneyRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FramedVehicleJourneyRefStructure $item
     * @return \StructType\AbstractDistributorItemStructure
     */
    public function addToFeederVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FramedVehicleJourneyRefStructure) {
            throw new \InvalidArgumentException(sprintf('The FeederVehicleJourneyRef property can only contain items of \StructType\FramedVehicleJourneyRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeederVehicleJourneyRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractDistributorItemStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
