<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Abstract CALL at stop.
 * @subpackage Structs
 */
class AbstractCallStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * Constructor method for AbstractCallStructure
     * @uses AbstractCallStructure::setStopPointRef()
     * @uses AbstractCallStructure::setVisitNumber()
     * @uses AbstractCallStructure::setOrder()
     * @uses AbstractCallStructure::setStopPointName()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, \StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setStopPointName($stopPointName);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\AbstractCallStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\AbstractCallStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\AbstractCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\AbstractCallStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
