<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Subscribe ServiceType
 * @subpackage Services
 */
class Subscribe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Subscribe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsSubscriptionRequestInfoStructure $subscriptionRequestInfo
     * @param \StructType\SiriSubscriptionRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function Subscribe(\StructType\WsSubscriptionRequestInfoStructure $subscriptionRequestInfo, \StructType\SiriSubscriptionRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->Subscribe($subscriptionRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
