<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lines ServiceType
 * @subpackage Services
 */
class Lines extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LinesDiscovery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LinesDiscoveryRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function LinesDiscovery(\StructType\LinesDiscoveryRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->LinesDiscovery($request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
