<?php

namespace EnumType;

/**
 * This class stands for VmsTypeEnum EnumType
 * @subpackage Enumerations
 */
class VmsTypeEnum
{
    /**
     * Constant for value 'colourGraphic'
     * @return string 'colourGraphic'
     */
    const VALUE_COLOUR_GRAPHIC = 'colourGraphic';
    /**
     * Constant for value 'continuousSign'
     * @return string 'continuousSign'
     */
    const VALUE_CONTINUOUS_SIGN = 'continuousSign';
    /**
     * Constant for value 'monochromeGraphic'
     * @return string 'monochromeGraphic'
     */
    const VALUE_MONOCHROME_GRAPHIC = 'monochromeGraphic';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COLOUR_GRAPHIC
     * @uses self::VALUE_CONTINUOUS_SIGN
     * @uses self::VALUE_MONOCHROME_GRAPHIC
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COLOUR_GRAPHIC,
            self::VALUE_CONTINUOUS_SIGN,
            self::VALUE_MONOCHROME_GRAPHIC,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
