<?php

namespace EnumType;

/**
 * This class stands for VehicleTypeEnum EnumType
 * @subpackage Enumerations
 */
class VehicleTypeEnum
{
    /**
     * Constant for value 'anyVehicle'
     * @return string 'anyVehicle'
     */
    const VALUE_ANY_VEHICLE = 'anyVehicle';
    /**
     * Constant for value 'articulatedVehicle'
     * @return string 'articulatedVehicle'
     */
    const VALUE_ARTICULATED_VEHICLE = 'articulatedVehicle';
    /**
     * Constant for value 'bicycle'
     * @return string 'bicycle'
     */
    const VALUE_BICYCLE = 'bicycle';
    /**
     * Constant for value 'bus'
     * @return string 'bus'
     */
    const VALUE_BUS = 'bus';
    /**
     * Constant for value 'car'
     * @return string 'car'
     */
    const VALUE_CAR = 'car';
    /**
     * Constant for value 'caravan'
     * @return string 'caravan'
     */
    const VALUE_CARAVAN = 'caravan';
    /**
     * Constant for value 'carOrLightVehicle'
     * @return string 'carOrLightVehicle'
     */
    const VALUE_CAR_OR_LIGHT_VEHICLE = 'carOrLightVehicle';
    /**
     * Constant for value 'carWithCaravan'
     * @return string 'carWithCaravan'
     */
    const VALUE_CAR_WITH_CARAVAN = 'carWithCaravan';
    /**
     * Constant for value 'carWithTrailer'
     * @return string 'carWithTrailer'
     */
    const VALUE_CAR_WITH_TRAILER = 'carWithTrailer';
    /**
     * Constant for value 'fourWheelDrive'
     * @return string 'fourWheelDrive'
     */
    const VALUE_FOUR_WHEEL_DRIVE = 'fourWheelDrive';
    /**
     * Constant for value 'highSidedVehicle'
     * @return string 'highSidedVehicle'
     */
    const VALUE_HIGH_SIDED_VEHICLE = 'highSidedVehicle';
    /**
     * Constant for value 'lorry'
     * @return string 'lorry'
     */
    const VALUE_LORRY = 'lorry';
    /**
     * Constant for value 'moped'
     * @return string 'moped'
     */
    const VALUE_MOPED = 'moped';
    /**
     * Constant for value 'motorcycle'
     * @return string 'motorcycle'
     */
    const VALUE_MOTORCYCLE = 'motorcycle';
    /**
     * Constant for value 'motorcycleWithSideCar'
     * @return string 'motorcycleWithSideCar'
     */
    const VALUE_MOTORCYCLE_WITH_SIDE_CAR = 'motorcycleWithSideCar';
    /**
     * Constant for value 'motorscooter'
     * @return string 'motorscooter'
     */
    const VALUE_MOTORSCOOTER = 'motorscooter';
    /**
     * Constant for value 'tanker'
     * @return string 'tanker'
     */
    const VALUE_TANKER = 'tanker';
    /**
     * Constant for value 'threeWheeledVehicle'
     * @return string 'threeWheeledVehicle'
     */
    const VALUE_THREE_WHEELED_VEHICLE = 'threeWheeledVehicle';
    /**
     * Constant for value 'trailer'
     * @return string 'trailer'
     */
    const VALUE_TRAILER = 'trailer';
    /**
     * Constant for value 'tram'
     * @return string 'tram'
     */
    const VALUE_TRAM = 'tram';
    /**
     * Constant for value 'twoWheeledVehicle'
     * @return string 'twoWheeledVehicle'
     */
    const VALUE_TWO_WHEELED_VEHICLE = 'twoWheeledVehicle';
    /**
     * Constant for value 'van'
     * @return string 'van'
     */
    const VALUE_VAN = 'van';
    /**
     * Constant for value 'vehicleWithCatalyticConverter'
     * @return string 'vehicleWithCatalyticConverter'
     */
    const VALUE_VEHICLE_WITH_CATALYTIC_CONVERTER = 'vehicleWithCatalyticConverter';
    /**
     * Constant for value 'vehicleWithoutCatalyticConverter'
     * @return string 'vehicleWithoutCatalyticConverter'
     */
    const VALUE_VEHICLE_WITHOUT_CATALYTIC_CONVERTER = 'vehicleWithoutCatalyticConverter';
    /**
     * Constant for value 'vehicleWithCaravan'
     * @return string 'vehicleWithCaravan'
     */
    const VALUE_VEHICLE_WITH_CARAVAN = 'vehicleWithCaravan';
    /**
     * Constant for value 'vehicleWithTrailer'
     * @return string 'vehicleWithTrailer'
     */
    const VALUE_VEHICLE_WITH_TRAILER = 'vehicleWithTrailer';
    /**
     * Constant for value 'withEvenNumberedRegistrationPlates'
     * @return string 'withEvenNumberedRegistrationPlates'
     */
    const VALUE_WITH_EVEN_NUMBERED_REGISTRATION_PLATES = 'withEvenNumberedRegistrationPlates';
    /**
     * Constant for value 'withOddNumberedRegistrationPlates'
     * @return string 'withOddNumberedRegistrationPlates'
     */
    const VALUE_WITH_ODD_NUMBERED_REGISTRATION_PLATES = 'withOddNumberedRegistrationPlates';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANY_VEHICLE
     * @uses self::VALUE_ARTICULATED_VEHICLE
     * @uses self::VALUE_BICYCLE
     * @uses self::VALUE_BUS
     * @uses self::VALUE_CAR
     * @uses self::VALUE_CARAVAN
     * @uses self::VALUE_CAR_OR_LIGHT_VEHICLE
     * @uses self::VALUE_CAR_WITH_CARAVAN
     * @uses self::VALUE_CAR_WITH_TRAILER
     * @uses self::VALUE_FOUR_WHEEL_DRIVE
     * @uses self::VALUE_HIGH_SIDED_VEHICLE
     * @uses self::VALUE_LORRY
     * @uses self::VALUE_MOPED
     * @uses self::VALUE_MOTORCYCLE
     * @uses self::VALUE_MOTORCYCLE_WITH_SIDE_CAR
     * @uses self::VALUE_MOTORSCOOTER
     * @uses self::VALUE_TANKER
     * @uses self::VALUE_THREE_WHEELED_VEHICLE
     * @uses self::VALUE_TRAILER
     * @uses self::VALUE_TRAM
     * @uses self::VALUE_TWO_WHEELED_VEHICLE
     * @uses self::VALUE_VAN
     * @uses self::VALUE_VEHICLE_WITH_CATALYTIC_CONVERTER
     * @uses self::VALUE_VEHICLE_WITHOUT_CATALYTIC_CONVERTER
     * @uses self::VALUE_VEHICLE_WITH_CARAVAN
     * @uses self::VALUE_VEHICLE_WITH_TRAILER
     * @uses self::VALUE_WITH_EVEN_NUMBERED_REGISTRATION_PLATES
     * @uses self::VALUE_WITH_ODD_NUMBERED_REGISTRATION_PLATES
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY_VEHICLE,
            self::VALUE_ARTICULATED_VEHICLE,
            self::VALUE_BICYCLE,
            self::VALUE_BUS,
            self::VALUE_CAR,
            self::VALUE_CARAVAN,
            self::VALUE_CAR_OR_LIGHT_VEHICLE,
            self::VALUE_CAR_WITH_CARAVAN,
            self::VALUE_CAR_WITH_TRAILER,
            self::VALUE_FOUR_WHEEL_DRIVE,
            self::VALUE_HIGH_SIDED_VEHICLE,
            self::VALUE_LORRY,
            self::VALUE_MOPED,
            self::VALUE_MOTORCYCLE,
            self::VALUE_MOTORCYCLE_WITH_SIDE_CAR,
            self::VALUE_MOTORSCOOTER,
            self::VALUE_TANKER,
            self::VALUE_THREE_WHEELED_VEHICLE,
            self::VALUE_TRAILER,
            self::VALUE_TRAM,
            self::VALUE_TWO_WHEELED_VEHICLE,
            self::VALUE_VAN,
            self::VALUE_VEHICLE_WITH_CATALYTIC_CONVERTER,
            self::VALUE_VEHICLE_WITHOUT_CATALYTIC_CONVERTER,
            self::VALUE_VEHICLE_WITH_CARAVAN,
            self::VALUE_VEHICLE_WITH_TRAILER,
            self::VALUE_WITH_EVEN_NUMBERED_REGISTRATION_PLATES,
            self::VALUE_WITH_ODD_NUMBERED_REGISTRATION_PLATES,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
