<?php

namespace EnumType;

/**
 * This class stands for VehicleObstructionTypeEnum EnumType
 * @subpackage Enumerations
 */
class VehicleObstructionTypeEnum
{
    /**
     * Constant for value 'abandonedVehicle'
     * @return string 'abandonedVehicle'
     */
    const VALUE_ABANDONED_VEHICLE = 'abandonedVehicle';
    /**
     * Constant for value 'abnormalLoad'
     * @return string 'abnormalLoad'
     */
    const VALUE_ABNORMAL_LOAD = 'abnormalLoad';
    /**
     * Constant for value 'brokenDownBus'
     * @return string 'brokenDownBus'
     */
    const VALUE_BROKEN_DOWN_BUS = 'brokenDownBus';
    /**
     * Constant for value 'brokenDownHeavyLorry'
     * @return string 'brokenDownHeavyLorry'
     */
    const VALUE_BROKEN_DOWN_HEAVY_LORRY = 'brokenDownHeavyLorry';
    /**
     * Constant for value 'brokenDownVehicle'
     * @return string 'brokenDownVehicle'
     */
    const VALUE_BROKEN_DOWN_VEHICLE = 'brokenDownVehicle';
    /**
     * Constant for value 'convoy'
     * @return string 'convoy'
     */
    const VALUE_CONVOY = 'convoy';
    /**
     * Constant for value 'damagedVehicle'
     * @return string 'damagedVehicle'
     */
    const VALUE_DAMAGED_VEHICLE = 'damagedVehicle';
    /**
     * Constant for value 'dangerousSlowMovingVehicle'
     * @return string 'dangerousSlowMovingVehicle'
     */
    const VALUE_DANGEROUS_SLOW_MOVING_VEHICLE = 'dangerousSlowMovingVehicle';
    /**
     * Constant for value 'emergencyVehicle'
     * @return string 'emergencyVehicle'
     */
    const VALUE_EMERGENCY_VEHICLE = 'emergencyVehicle';
    /**
     * Constant for value 'highSpeedEmergencyVehicle'
     * @return string 'highSpeedEmergencyVehicle'
     */
    const VALUE_HIGH_SPEED_EMERGENCY_VEHICLE = 'highSpeedEmergencyVehicle';
    /**
     * Constant for value 'longLoad'
     * @return string 'longLoad'
     */
    const VALUE_LONG_LOAD = 'longLoad';
    /**
     * Constant for value 'militaryConvoy'
     * @return string 'militaryConvoy'
     */
    const VALUE_MILITARY_CONVOY = 'militaryConvoy';
    /**
     * Constant for value 'overheightVehicle'
     * @return string 'overheightVehicle'
     */
    const VALUE_OVERHEIGHT_VEHICLE = 'overheightVehicle';
    /**
     * Constant for value 'prohibitedVehicleOnTheRoadway'
     * @return string 'prohibitedVehicleOnTheRoadway'
     */
    const VALUE_PROHIBITED_VEHICLE_ON_THE_ROADWAY = 'prohibitedVehicleOnTheRoadway';
    /**
     * Constant for value 'saltingOrGrittingVehicleInUse'
     * @return string 'saltingOrGrittingVehicleInUse'
     */
    const VALUE_SALTING_OR_GRITTING_VEHICLE_IN_USE = 'saltingOrGrittingVehicleInUse';
    /**
     * Constant for value 'slowMovingMaintenanceVehicle'
     * @return string 'slowMovingMaintenanceVehicle'
     */
    const VALUE_SLOW_MOVING_MAINTENANCE_VEHICLE = 'slowMovingMaintenanceVehicle';
    /**
     * Constant for value 'slowVehicle'
     * @return string 'slowVehicle'
     */
    const VALUE_SLOW_VEHICLE = 'slowVehicle';
    /**
     * Constant for value 'snowplough'
     * @return string 'snowplough'
     */
    const VALUE_SNOWPLOUGH = 'snowplough';
    /**
     * Constant for value 'trackLayingVehicle'
     * @return string 'trackLayingVehicle'
     */
    const VALUE_TRACK_LAYING_VEHICLE = 'trackLayingVehicle';
    /**
     * Constant for value 'unlitVehicleOnTheRoad'
     * @return string 'unlitVehicleOnTheRoad'
     */
    const VALUE_UNLIT_VEHICLE_ON_THE_ROAD = 'unlitVehicleOnTheRoad';
    /**
     * Constant for value 'vehicleOnFire'
     * @return string 'vehicleOnFire'
     */
    const VALUE_VEHICLE_ON_FIRE = 'vehicleOnFire';
    /**
     * Constant for value 'vehicleCarryingHazardousMaterials'
     * @return string 'vehicleCarryingHazardousMaterials'
     */
    const VALUE_VEHICLE_CARRYING_HAZARDOUS_MATERIALS = 'vehicleCarryingHazardousMaterials';
    /**
     * Constant for value 'vehicleInDifficulty'
     * @return string 'vehicleInDifficulty'
     */
    const VALUE_VEHICLE_IN_DIFFICULTY = 'vehicleInDifficulty';
    /**
     * Constant for value 'vehicleOnWrongCarriageway'
     * @return string 'vehicleOnWrongCarriageway'
     */
    const VALUE_VEHICLE_ON_WRONG_CARRIAGEWAY = 'vehicleOnWrongCarriageway';
    /**
     * Constant for value 'vehicleStuck'
     * @return string 'vehicleStuck'
     */
    const VALUE_VEHICLE_STUCK = 'vehicleStuck';
    /**
     * Constant for value 'vehicleStuckUnderBridge'
     * @return string 'vehicleStuckUnderBridge'
     */
    const VALUE_VEHICLE_STUCK_UNDER_BRIDGE = 'vehicleStuckUnderBridge';
    /**
     * Constant for value 'vehicleWithOverheightLoad'
     * @return string 'vehicleWithOverheightLoad'
     */
    const VALUE_VEHICLE_WITH_OVERHEIGHT_LOAD = 'vehicleWithOverheightLoad';
    /**
     * Constant for value 'vehicleWithOverwideLoad'
     * @return string 'vehicleWithOverwideLoad'
     */
    const VALUE_VEHICLE_WITH_OVERWIDE_LOAD = 'vehicleWithOverwideLoad';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABANDONED_VEHICLE
     * @uses self::VALUE_ABNORMAL_LOAD
     * @uses self::VALUE_BROKEN_DOWN_BUS
     * @uses self::VALUE_BROKEN_DOWN_HEAVY_LORRY
     * @uses self::VALUE_BROKEN_DOWN_VEHICLE
     * @uses self::VALUE_CONVOY
     * @uses self::VALUE_DAMAGED_VEHICLE
     * @uses self::VALUE_DANGEROUS_SLOW_MOVING_VEHICLE
     * @uses self::VALUE_EMERGENCY_VEHICLE
     * @uses self::VALUE_HIGH_SPEED_EMERGENCY_VEHICLE
     * @uses self::VALUE_LONG_LOAD
     * @uses self::VALUE_MILITARY_CONVOY
     * @uses self::VALUE_OVERHEIGHT_VEHICLE
     * @uses self::VALUE_PROHIBITED_VEHICLE_ON_THE_ROADWAY
     * @uses self::VALUE_SALTING_OR_GRITTING_VEHICLE_IN_USE
     * @uses self::VALUE_SLOW_MOVING_MAINTENANCE_VEHICLE
     * @uses self::VALUE_SLOW_VEHICLE
     * @uses self::VALUE_SNOWPLOUGH
     * @uses self::VALUE_TRACK_LAYING_VEHICLE
     * @uses self::VALUE_UNLIT_VEHICLE_ON_THE_ROAD
     * @uses self::VALUE_VEHICLE_ON_FIRE
     * @uses self::VALUE_VEHICLE_CARRYING_HAZARDOUS_MATERIALS
     * @uses self::VALUE_VEHICLE_IN_DIFFICULTY
     * @uses self::VALUE_VEHICLE_ON_WRONG_CARRIAGEWAY
     * @uses self::VALUE_VEHICLE_STUCK
     * @uses self::VALUE_VEHICLE_STUCK_UNDER_BRIDGE
     * @uses self::VALUE_VEHICLE_WITH_OVERHEIGHT_LOAD
     * @uses self::VALUE_VEHICLE_WITH_OVERWIDE_LOAD
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABANDONED_VEHICLE,
            self::VALUE_ABNORMAL_LOAD,
            self::VALUE_BROKEN_DOWN_BUS,
            self::VALUE_BROKEN_DOWN_HEAVY_LORRY,
            self::VALUE_BROKEN_DOWN_VEHICLE,
            self::VALUE_CONVOY,
            self::VALUE_DAMAGED_VEHICLE,
            self::VALUE_DANGEROUS_SLOW_MOVING_VEHICLE,
            self::VALUE_EMERGENCY_VEHICLE,
            self::VALUE_HIGH_SPEED_EMERGENCY_VEHICLE,
            self::VALUE_LONG_LOAD,
            self::VALUE_MILITARY_CONVOY,
            self::VALUE_OVERHEIGHT_VEHICLE,
            self::VALUE_PROHIBITED_VEHICLE_ON_THE_ROADWAY,
            self::VALUE_SALTING_OR_GRITTING_VEHICLE_IN_USE,
            self::VALUE_SLOW_MOVING_MAINTENANCE_VEHICLE,
            self::VALUE_SLOW_VEHICLE,
            self::VALUE_SNOWPLOUGH,
            self::VALUE_TRACK_LAYING_VEHICLE,
            self::VALUE_UNLIT_VEHICLE_ON_THE_ROAD,
            self::VALUE_VEHICLE_ON_FIRE,
            self::VALUE_VEHICLE_CARRYING_HAZARDOUS_MATERIALS,
            self::VALUE_VEHICLE_IN_DIFFICULTY,
            self::VALUE_VEHICLE_ON_WRONG_CARRIAGEWAY,
            self::VALUE_VEHICLE_STUCK,
            self::VALUE_VEHICLE_STUCK_UNDER_BRIDGE,
            self::VALUE_VEHICLE_WITH_OVERHEIGHT_LOAD,
            self::VALUE_VEHICLE_WITH_OVERWIDE_LOAD,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
