<?php

namespace EnumType;

/**
 * This class stands for UrlLinkTypeEnum EnumType
 * @subpackage Enumerations
 */
class UrlLinkTypeEnum
{
    /**
     * Constant for value 'documentPdf'
     * @return string 'documentPdf'
     */
    const VALUE_DOCUMENT_PDF = 'documentPdf';
    /**
     * Constant for value 'html'
     * @return string 'html'
     */
    const VALUE_HTML = 'html';
    /**
     * Constant for value 'image'
     * @return string 'image'
     */
    const VALUE_IMAGE = 'image';
    /**
     * Constant for value 'rss'
     * @return string 'rss'
     */
    const VALUE_RSS = 'rss';
    /**
     * Constant for value 'videoStream'
     * @return string 'videoStream'
     */
    const VALUE_VIDEO_STREAM = 'videoStream';
    /**
     * Constant for value 'voiceStream'
     * @return string 'voiceStream'
     */
    const VALUE_VOICE_STREAM = 'voiceStream';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DOCUMENT_PDF
     * @uses self::VALUE_HTML
     * @uses self::VALUE_IMAGE
     * @uses self::VALUE_RSS
     * @uses self::VALUE_VIDEO_STREAM
     * @uses self::VALUE_VOICE_STREAM
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOCUMENT_PDF,
            self::VALUE_HTML,
            self::VALUE_IMAGE,
            self::VALUE_RSS,
            self::VALUE_VIDEO_STREAM,
            self::VALUE_VOICE_STREAM,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
