<?php

namespace EnumType;

/**
 * This class stands for UrgencyEnum EnumType
 * @subpackage Enumerations
 */
class UrgencyEnum
{
    /**
     * Constant for value 'extremelyUrgent'
     * @return string 'extremelyUrgent'
     */
    const VALUE_EXTREMELY_URGENT = 'extremelyUrgent';
    /**
     * Constant for value 'urgent'
     * @return string 'urgent'
     */
    const VALUE_URGENT = 'urgent';
    /**
     * Constant for value 'normalUrgency'
     * @return string 'normalUrgency'
     */
    const VALUE_NORMAL_URGENCY = 'normalUrgency';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXTREMELY_URGENT
     * @uses self::VALUE_URGENT
     * @uses self::VALUE_NORMAL_URGENCY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXTREMELY_URGENT,
            self::VALUE_URGENT,
            self::VALUE_NORMAL_URGENCY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
