<?php

namespace EnumType;

/**
 * This class stands for TravelTimeTrendTypeEnum EnumType
 * @subpackage Enumerations
 */
class TravelTimeTrendTypeEnum
{
    /**
     * Constant for value 'decreasing'
     * @return string 'decreasing'
     */
    const VALUE_DECREASING = 'decreasing';
    /**
     * Constant for value 'increasing'
     * @return string 'increasing'
     */
    const VALUE_INCREASING = 'increasing';
    /**
     * Constant for value 'stable'
     * @return string 'stable'
     */
    const VALUE_STABLE = 'stable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DECREASING
     * @uses self::VALUE_INCREASING
     * @uses self::VALUE_STABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DECREASING,
            self::VALUE_INCREASING,
            self::VALUE_STABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
