<?php

namespace EnumType;

/**
 * This class stands for TransitServiceInformationEnum EnumType
 * @subpackage Enumerations
 */
class TransitServiceInformationEnum
{
    /**
     * Constant for value 'cancellations'
     * @return string 'cancellations'
     */
    const VALUE_CANCELLATIONS = 'cancellations';
    /**
     * Constant for value 'delayDueToBadWeather'
     * @return string 'delayDueToBadWeather'
     */
    const VALUE_DELAY_DUE_TO_BAD_WEATHER = 'delayDueToBadWeather';
    /**
     * Constant for value 'delayDueToRepairs'
     * @return string 'delayDueToRepairs'
     */
    const VALUE_DELAY_DUE_TO_REPAIRS = 'delayDueToRepairs';
    /**
     * Constant for value 'delayedUntilFurtherNotice'
     * @return string 'delayedUntilFurtherNotice'
     */
    const VALUE_DELAYED_UNTIL_FURTHER_NOTICE = 'delayedUntilFurtherNotice';
    /**
     * Constant for value 'delaysDueToFlotsam'
     * @return string 'delaysDueToFlotsam'
     */
    const VALUE_DELAYS_DUE_TO_FLOTSAM = 'delaysDueToFlotsam';
    /**
     * Constant for value 'departureOnSchedule'
     * @return string 'departureOnSchedule'
     */
    const VALUE_DEPARTURE_ON_SCHEDULE = 'departureOnSchedule';
    /**
     * Constant for value 'ferryReplacedByIceRoad'
     * @return string 'ferryReplacedByIceRoad'
     */
    const VALUE_FERRY_REPLACED_BY_ICE_ROAD = 'ferryReplacedByIceRoad';
    /**
     * Constant for value 'freeShuttleServiceOperating'
     * @return string 'freeShuttleServiceOperating'
     */
    const VALUE_FREE_SHUTTLE_SERVICE_OPERATING = 'freeShuttleServiceOperating';
    /**
     * Constant for value 'informationServiceNotAvailable'
     * @return string 'informationServiceNotAvailable'
     */
    const VALUE_INFORMATION_SERVICE_NOT_AVAILABLE = 'informationServiceNotAvailable';
    /**
     * Constant for value 'irregularServiceDelays'
     * @return string 'irregularServiceDelays'
     */
    const VALUE_IRREGULAR_SERVICE_DELAYS = 'irregularServiceDelays';
    /**
     * Constant for value 'loadCapacityChanged'
     * @return string 'loadCapacityChanged'
     */
    const VALUE_LOAD_CAPACITY_CHANGED = 'loadCapacityChanged';
    /**
     * Constant for value 'restrictionsForLongerVehicles'
     * @return string 'restrictionsForLongerVehicles'
     */
    const VALUE_RESTRICTIONS_FOR_LONGER_VEHICLES = 'restrictionsForLongerVehicles';
    /**
     * Constant for value 'serviceDelays'
     * @return string 'serviceDelays'
     */
    const VALUE_SERVICE_DELAYS = 'serviceDelays';
    /**
     * Constant for value 'serviceDelaysOfUncertainDuration'
     * @return string 'serviceDelaysOfUncertainDuration'
     */
    const VALUE_SERVICE_DELAYS_OF_UNCERTAIN_DURATION = 'serviceDelaysOfUncertainDuration';
    /**
     * Constant for value 'serviceFullyBooked'
     * @return string 'serviceFullyBooked'
     */
    const VALUE_SERVICE_FULLY_BOOKED = 'serviceFullyBooked';
    /**
     * Constant for value 'serviceNotOperating'
     * @return string 'serviceNotOperating'
     */
    const VALUE_SERVICE_NOT_OPERATING = 'serviceNotOperating';
    /**
     * Constant for value 'serviceNotOperatingSubstituteServiceAvailable'
     * @return string 'serviceNotOperatingSubstituteServiceAvailable'
     */
    const VALUE_SERVICE_NOT_OPERATING_SUBSTITUTE_SERVICE_AVAILABLE = 'serviceNotOperatingSubstituteServiceAvailable';
    /**
     * Constant for value 'serviceSuspended'
     * @return string 'serviceSuspended'
     */
    const VALUE_SERVICE_SUSPENDED = 'serviceSuspended';
    /**
     * Constant for value 'serviceWithdrawn'
     * @return string 'serviceWithdrawn'
     */
    const VALUE_SERVICE_WITHDRAWN = 'serviceWithdrawn';
    /**
     * Constant for value 'shuttleServiceOperating'
     * @return string 'shuttleServiceOperating'
     */
    const VALUE_SHUTTLE_SERVICE_OPERATING = 'shuttleServiceOperating';
    /**
     * Constant for value 'temporaryChangesToTimetables'
     * @return string 'temporaryChangesToTimetables'
     */
    const VALUE_TEMPORARY_CHANGES_TO_TIMETABLES = 'temporaryChangesToTimetables';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CANCELLATIONS
     * @uses self::VALUE_DELAY_DUE_TO_BAD_WEATHER
     * @uses self::VALUE_DELAY_DUE_TO_REPAIRS
     * @uses self::VALUE_DELAYED_UNTIL_FURTHER_NOTICE
     * @uses self::VALUE_DELAYS_DUE_TO_FLOTSAM
     * @uses self::VALUE_DEPARTURE_ON_SCHEDULE
     * @uses self::VALUE_FERRY_REPLACED_BY_ICE_ROAD
     * @uses self::VALUE_FREE_SHUTTLE_SERVICE_OPERATING
     * @uses self::VALUE_INFORMATION_SERVICE_NOT_AVAILABLE
     * @uses self::VALUE_IRREGULAR_SERVICE_DELAYS
     * @uses self::VALUE_LOAD_CAPACITY_CHANGED
     * @uses self::VALUE_RESTRICTIONS_FOR_LONGER_VEHICLES
     * @uses self::VALUE_SERVICE_DELAYS
     * @uses self::VALUE_SERVICE_DELAYS_OF_UNCERTAIN_DURATION
     * @uses self::VALUE_SERVICE_FULLY_BOOKED
     * @uses self::VALUE_SERVICE_NOT_OPERATING
     * @uses self::VALUE_SERVICE_NOT_OPERATING_SUBSTITUTE_SERVICE_AVAILABLE
     * @uses self::VALUE_SERVICE_SUSPENDED
     * @uses self::VALUE_SERVICE_WITHDRAWN
     * @uses self::VALUE_SHUTTLE_SERVICE_OPERATING
     * @uses self::VALUE_TEMPORARY_CHANGES_TO_TIMETABLES
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CANCELLATIONS,
            self::VALUE_DELAY_DUE_TO_BAD_WEATHER,
            self::VALUE_DELAY_DUE_TO_REPAIRS,
            self::VALUE_DELAYED_UNTIL_FURTHER_NOTICE,
            self::VALUE_DELAYS_DUE_TO_FLOTSAM,
            self::VALUE_DEPARTURE_ON_SCHEDULE,
            self::VALUE_FERRY_REPLACED_BY_ICE_ROAD,
            self::VALUE_FREE_SHUTTLE_SERVICE_OPERATING,
            self::VALUE_INFORMATION_SERVICE_NOT_AVAILABLE,
            self::VALUE_IRREGULAR_SERVICE_DELAYS,
            self::VALUE_LOAD_CAPACITY_CHANGED,
            self::VALUE_RESTRICTIONS_FOR_LONGER_VEHICLES,
            self::VALUE_SERVICE_DELAYS,
            self::VALUE_SERVICE_DELAYS_OF_UNCERTAIN_DURATION,
            self::VALUE_SERVICE_FULLY_BOOKED,
            self::VALUE_SERVICE_NOT_OPERATING,
            self::VALUE_SERVICE_NOT_OPERATING_SUBSTITUTE_SERVICE_AVAILABLE,
            self::VALUE_SERVICE_SUSPENDED,
            self::VALUE_SERVICE_WITHDRAWN,
            self::VALUE_SHUTTLE_SERVICE_OPERATING,
            self::VALUE_TEMPORARY_CHANGES_TO_TIMETABLES,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
