<?php

namespace EnumType;

/**
 * This class stands for TrafficStatusEnum EnumType
 * @subpackage Enumerations
 */
class TrafficStatusEnum
{
    /**
     * Constant for value 'impossible'
     * @return string 'impossible'
     */
    const VALUE_IMPOSSIBLE = 'impossible';
    /**
     * Constant for value 'congested'
     * @return string 'congested'
     */
    const VALUE_CONGESTED = 'congested';
    /**
     * Constant for value 'heavy'
     * @return string 'heavy'
     */
    const VALUE_HEAVY = 'heavy';
    /**
     * Constant for value 'freeFlow'
     * @return string 'freeFlow'
     */
    const VALUE_FREE_FLOW = 'freeFlow';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMPOSSIBLE
     * @uses self::VALUE_CONGESTED
     * @uses self::VALUE_HEAVY
     * @uses self::VALUE_FREE_FLOW
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMPOSSIBLE,
            self::VALUE_CONGESTED,
            self::VALUE_HEAVY,
            self::VALUE_FREE_FLOW,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
