<?php

namespace EnumType;

/**
 * This class stands for TrafficFlowCharacteristicsEnum EnumType
 * @subpackage Enumerations
 */
class TrafficFlowCharacteristicsEnum
{
    /**
     * Constant for value 'erraticFlow'
     * @return string 'erraticFlow'
     */
    const VALUE_ERRATIC_FLOW = 'erraticFlow';
    /**
     * Constant for value 'smoothFlow'
     * @return string 'smoothFlow'
     */
    const VALUE_SMOOTH_FLOW = 'smoothFlow';
    /**
     * Constant for value 'stopAndGo'
     * @return string 'stopAndGo'
     */
    const VALUE_STOP_AND_GO = 'stopAndGo';
    /**
     * Constant for value 'trafficBlocked'
     * @return string 'trafficBlocked'
     */
    const VALUE_TRAFFIC_BLOCKED = 'trafficBlocked';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERRATIC_FLOW
     * @uses self::VALUE_SMOOTH_FLOW
     * @uses self::VALUE_STOP_AND_GO
     * @uses self::VALUE_TRAFFIC_BLOCKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERRATIC_FLOW,
            self::VALUE_SMOOTH_FLOW,
            self::VALUE_STOP_AND_GO,
            self::VALUE_TRAFFIC_BLOCKED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
