<?php

namespace EnumType;

/**
 * This class stands for TpegLoc02DirectionTypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc02DirectionTypeEnum
{
    /**
     * Constant for value 'allDirections'
     * @return string 'allDirections'
     */
    const VALUE_ALL_DIRECTIONS = 'allDirections';
    /**
     * Constant for value 'anticlockwise'
     * @return string 'anticlockwise'
     */
    const VALUE_ANTICLOCKWISE = 'anticlockwise';
    /**
     * Constant for value 'bothWays'
     * @return string 'bothWays'
     */
    const VALUE_BOTH_WAYS = 'bothWays';
    /**
     * Constant for value 'clockwise'
     * @return string 'clockwise'
     */
    const VALUE_CLOCKWISE = 'clockwise';
    /**
     * Constant for value 'eastBound'
     * @return string 'eastBound'
     */
    const VALUE_EAST_BOUND = 'eastBound';
    /**
     * Constant for value 'innerRing'
     * @return string 'innerRing'
     */
    const VALUE_INNER_RING = 'innerRing';
    /**
     * Constant for value 'northBound'
     * @return string 'northBound'
     */
    const VALUE_NORTH_BOUND = 'northBound';
    /**
     * Constant for value 'northEastBound'
     * @return string 'northEastBound'
     */
    const VALUE_NORTH_EAST_BOUND = 'northEastBound';
    /**
     * Constant for value 'northWestBound'
     * @return string 'northWestBound'
     */
    const VALUE_NORTH_WEST_BOUND = 'northWestBound';
    /**
     * Constant for value 'opposite'
     * @return string 'opposite'
     */
    const VALUE_OPPOSITE = 'opposite';
    /**
     * Constant for value 'outerRing'
     * @return string 'outerRing'
     */
    const VALUE_OUTER_RING = 'outerRing';
    /**
     * Constant for value 'southBound'
     * @return string 'southBound'
     */
    const VALUE_SOUTH_BOUND = 'southBound';
    /**
     * Constant for value 'southEastBound'
     * @return string 'southEastBound'
     */
    const VALUE_SOUTH_EAST_BOUND = 'southEastBound';
    /**
     * Constant for value 'southWestBound'
     * @return string 'southWestBound'
     */
    const VALUE_SOUTH_WEST_BOUND = 'southWestBound';
    /**
     * Constant for value 'westBound'
     * @return string 'westBound'
     */
    const VALUE_WEST_BOUND = 'westBound';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_DIRECTIONS
     * @uses self::VALUE_ANTICLOCKWISE
     * @uses self::VALUE_BOTH_WAYS
     * @uses self::VALUE_CLOCKWISE
     * @uses self::VALUE_EAST_BOUND
     * @uses self::VALUE_INNER_RING
     * @uses self::VALUE_NORTH_BOUND
     * @uses self::VALUE_NORTH_EAST_BOUND
     * @uses self::VALUE_NORTH_WEST_BOUND
     * @uses self::VALUE_OPPOSITE
     * @uses self::VALUE_OUTER_RING
     * @uses self::VALUE_SOUTH_BOUND
     * @uses self::VALUE_SOUTH_EAST_BOUND
     * @uses self::VALUE_SOUTH_WEST_BOUND
     * @uses self::VALUE_WEST_BOUND
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_DIRECTIONS,
            self::VALUE_ANTICLOCKWISE,
            self::VALUE_BOTH_WAYS,
            self::VALUE_CLOCKWISE,
            self::VALUE_EAST_BOUND,
            self::VALUE_INNER_RING,
            self::VALUE_NORTH_BOUND,
            self::VALUE_NORTH_EAST_BOUND,
            self::VALUE_NORTH_WEST_BOUND,
            self::VALUE_OPPOSITE,
            self::VALUE_OUTER_RING,
            self::VALUE_SOUTH_BOUND,
            self::VALUE_SOUTH_EAST_BOUND,
            self::VALUE_SOUTH_WEST_BOUND,
            self::VALUE_WEST_BOUND,
            self::VALUE_UNKNOWN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
