<?php

namespace EnumType;

/**
 * This class stands for TimetableTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for timetable type TPEG pti_table 33.
 * @subpackage Enumerations
 */
class TimetableTypeEnumeration
{
    /**
     * Constant for value 'pti33_0'
     * @return string 'pti33_0'
     */
    const VALUE_PTI_33_0 = 'pti33_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti33_1'
     * @return string 'pti33_1'
     */
    const VALUE_PTI_33_1 = 'pti33_1';
    /**
     * Constant for value 'winter'
     * @return string 'winter'
     */
    const VALUE_WINTER = 'winter';
    /**
     * Constant for value 'pti33_2'
     * @return string 'pti33_2'
     */
    const VALUE_PTI_33_2 = 'pti33_2';
    /**
     * Constant for value 'spring'
     * @return string 'spring'
     */
    const VALUE_SPRING = 'spring';
    /**
     * Constant for value 'pti33_3'
     * @return string 'pti33_3'
     */
    const VALUE_PTI_33_3 = 'pti33_3';
    /**
     * Constant for value 'summer'
     * @return string 'summer'
     */
    const VALUE_SUMMER = 'summer';
    /**
     * Constant for value 'pti33_4'
     * @return string 'pti33_4'
     */
    const VALUE_PTI_33_4 = 'pti33_4';
    /**
     * Constant for value 'autumn'
     * @return string 'autumn'
     */
    const VALUE_AUTUMN = 'autumn';
    /**
     * Constant for value 'pti33_5'
     * @return string 'pti33_5'
     */
    const VALUE_PTI_33_5 = 'pti33_5';
    /**
     * Constant for value 'special'
     * @return string 'special'
     */
    const VALUE_SPECIAL = 'special';
    /**
     * Constant for value 'pti33_6'
     * @return string 'pti33_6'
     */
    const VALUE_PTI_33_6 = 'pti33_6';
    /**
     * Constant for value 'emergency'
     * @return string 'emergency'
     */
    const VALUE_EMERGENCY = 'emergency';
    /**
     * Constant for value 'pti33_255'
     * @return string 'pti33_255'
     */
    const VALUE_PTI_33_255 = 'pti33_255';
    /**
     * Constant for value 'undefinedTimetableType'
     * @return string 'undefinedTimetableType'
     */
    const VALUE_UNDEFINED_TIMETABLE_TYPE = 'undefinedTimetableType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_33_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_33_1
     * @uses self::VALUE_WINTER
     * @uses self::VALUE_PTI_33_2
     * @uses self::VALUE_SPRING
     * @uses self::VALUE_PTI_33_3
     * @uses self::VALUE_SUMMER
     * @uses self::VALUE_PTI_33_4
     * @uses self::VALUE_AUTUMN
     * @uses self::VALUE_PTI_33_5
     * @uses self::VALUE_SPECIAL
     * @uses self::VALUE_PTI_33_6
     * @uses self::VALUE_EMERGENCY
     * @uses self::VALUE_PTI_33_255
     * @uses self::VALUE_UNDEFINED_TIMETABLE_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_33_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_33_1,
            self::VALUE_WINTER,
            self::VALUE_PTI_33_2,
            self::VALUE_SPRING,
            self::VALUE_PTI_33_3,
            self::VALUE_SUMMER,
            self::VALUE_PTI_33_4,
            self::VALUE_AUTUMN,
            self::VALUE_PTI_33_5,
            self::VALUE_SPECIAL,
            self::VALUE_PTI_33_6,
            self::VALUE_EMERGENCY,
            self::VALUE_PTI_33_255,
            self::VALUE_UNDEFINED_TIMETABLE_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
