<?php

namespace EnumType;

/**
 * This class stands for StopVisitTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Visit Types to Return.
 * @subpackage Enumerations
 */
class StopVisitTypeEnumeration
{
    /**
     * Constant for value 'all'
     * @return string 'all'
     */
    const VALUE_ALL = 'all';
    /**
     * Constant for value 'arrivals'
     * @return string 'arrivals'
     */
    const VALUE_ARRIVALS = 'arrivals';
    /**
     * Constant for value 'departures'
     * @return string 'departures'
     */
    const VALUE_DEPARTURES = 'departures';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ARRIVALS
     * @uses self::VALUE_DEPARTURES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ARRIVALS,
            self::VALUE_DEPARTURES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
