<?php

namespace EnumType;

/**
 * This class stands for StopPointTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for TBookingStatus TPEG pti_table17.
 * @subpackage Enumerations
 */
class StopPointTypeEnumeration
{
    /**
     * Constant for value 'pti17_0'
     * @return string 'pti17_0'
     */
    const VALUE_PTI_17_0 = 'pti17_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti17_1'
     * @return string 'pti17_1'
     */
    const VALUE_PTI_17_1 = 'pti17_1';
    /**
     * Constant for value 'platformNumber'
     * @return string 'platformNumber'
     */
    const VALUE_PLATFORM_NUMBER = 'platformNumber';
    /**
     * Constant for value 'pti17_2'
     * @return string 'pti17_2'
     */
    const VALUE_PTI_17_2 = 'pti17_2';
    /**
     * Constant for value 'terminalGate'
     * @return string 'terminalGate'
     */
    const VALUE_TERMINAL_GATE = 'terminalGate';
    /**
     * Constant for value 'pti17_3'
     * @return string 'pti17_3'
     */
    const VALUE_PTI_17_3 = 'pti17_3';
    /**
     * Constant for value 'ferryBerth'
     * @return string 'ferryBerth'
     */
    const VALUE_FERRY_BERTH = 'ferryBerth';
    /**
     * Constant for value 'pti17_4'
     * @return string 'pti17_4'
     */
    const VALUE_PTI_17_4 = 'pti17_4';
    /**
     * Constant for value 'harbourPier'
     * @return string 'harbourPier'
     */
    const VALUE_HARBOUR_PIER = 'harbourPier';
    /**
     * Constant for value 'pti17_5'
     * @return string 'pti17_5'
     */
    const VALUE_PTI_17_5 = 'pti17_5';
    /**
     * Constant for value 'landingStage'
     * @return string 'landingStage'
     */
    const VALUE_LANDING_STAGE = 'landingStage';
    /**
     * Constant for value 'pti17_6'
     * @return string 'pti17_6'
     */
    const VALUE_PTI_17_6 = 'pti17_6';
    /**
     * Constant for value 'busStop'
     * @return string 'busStop'
     */
    const VALUE_BUS_STOP = 'busStop';
    /**
     * Constant for value 'pti17_255'
     * @return string 'pti17_255'
     */
    const VALUE_PTI_17_255 = 'pti17_255';
    /**
     * Constant for value 'undefinedBookingInformation'
     * @return string 'undefinedBookingInformation'
     */
    const VALUE_UNDEFINED_BOOKING_INFORMATION = 'undefinedBookingInformation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_17_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_17_1
     * @uses self::VALUE_PLATFORM_NUMBER
     * @uses self::VALUE_PTI_17_2
     * @uses self::VALUE_TERMINAL_GATE
     * @uses self::VALUE_PTI_17_3
     * @uses self::VALUE_FERRY_BERTH
     * @uses self::VALUE_PTI_17_4
     * @uses self::VALUE_HARBOUR_PIER
     * @uses self::VALUE_PTI_17_5
     * @uses self::VALUE_LANDING_STAGE
     * @uses self::VALUE_PTI_17_6
     * @uses self::VALUE_BUS_STOP
     * @uses self::VALUE_PTI_17_255
     * @uses self::VALUE_UNDEFINED_BOOKING_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_17_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_17_1,
            self::VALUE_PLATFORM_NUMBER,
            self::VALUE_PTI_17_2,
            self::VALUE_TERMINAL_GATE,
            self::VALUE_PTI_17_3,
            self::VALUE_FERRY_BERTH,
            self::VALUE_PTI_17_4,
            self::VALUE_HARBOUR_PIER,
            self::VALUE_PTI_17_5,
            self::VALUE_LANDING_STAGE,
            self::VALUE_PTI_17_6,
            self::VALUE_BUS_STOP,
            self::VALUE_PTI_17_255,
            self::VALUE_UNDEFINED_BOOKING_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
