<?php

namespace EnumType;

/**
 * This class stands for StopPlaceTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of STOP PLACE types.
 * @subpackage Enumerations
 */
class StopPlaceTypeEnumeration
{
    /**
     * Constant for value 'airport'
     * @return string 'airport'
     */
    const VALUE_AIRPORT = 'airport';
    /**
     * Constant for value 'railStation'
     * @return string 'railStation'
     */
    const VALUE_RAIL_STATION = 'railStation';
    /**
     * Constant for value 'metroStation'
     * @return string 'metroStation'
     */
    const VALUE_METRO_STATION = 'metroStation';
    /**
     * Constant for value 'coachStation'
     * @return string 'coachStation'
     */
    const VALUE_COACH_STATION = 'coachStation';
    /**
     * Constant for value 'busStation'
     * @return string 'busStation'
     */
    const VALUE_BUS_STATION = 'busStation';
    /**
     * Constant for value 'harbourPort'
     * @return string 'harbourPort'
     */
    const VALUE_HARBOUR_PORT = 'harbourPort';
    /**
     * Constant for value 'ferrytPort'
     * @return string 'ferrytPort'
     */
    const VALUE_FERRYT_PORT = 'ferrytPort';
    /**
     * Constant for value 'ferryStop'
     * @return string 'ferryStop'
     */
    const VALUE_FERRY_STOP = 'ferryStop';
    /**
     * Constant for value 'onStreetBus'
     * @return string 'onStreetBus'
     */
    const VALUE_ON_STREET_BUS = 'onStreetBus';
    /**
     * Constant for value 'onStreetTram'
     * @return string 'onStreetTram'
     */
    const VALUE_ON_STREET_TRAM = 'onStreetTram';
    /**
     * Constant for value 'skiLift'
     * @return string 'skiLift'
     */
    const VALUE_SKI_LIFT = 'skiLift';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_RAIL_STATION
     * @uses self::VALUE_METRO_STATION
     * @uses self::VALUE_COACH_STATION
     * @uses self::VALUE_BUS_STATION
     * @uses self::VALUE_HARBOUR_PORT
     * @uses self::VALUE_FERRYT_PORT
     * @uses self::VALUE_FERRY_STOP
     * @uses self::VALUE_ON_STREET_BUS
     * @uses self::VALUE_ON_STREET_TRAM
     * @uses self::VALUE_SKI_LIFT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORT,
            self::VALUE_RAIL_STATION,
            self::VALUE_METRO_STATION,
            self::VALUE_COACH_STATION,
            self::VALUE_BUS_STATION,
            self::VALUE_HARBOUR_PORT,
            self::VALUE_FERRYT_PORT,
            self::VALUE_FERRY_STOP,
            self::VALUE_ON_STREET_BUS,
            self::VALUE_ON_STREET_TRAM,
            self::VALUE_SKI_LIFT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
